package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__double
import scala.jdk.CollectionConverters.*
final case class GPSPointDimension(
    coordinates: zio.aws.pinpoint.model.GPSCoordinates,
    rangeInKilometers: Option[__double] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.GPSPointDimension = {
    import GPSPointDimension.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.GPSPointDimension
      .builder()
      .coordinates(coordinates.buildAwsValue())
      .optionallyWith(
        rangeInKilometers.map(value => __double.unwrap(value): java.lang.Double)
      )(_.rangeInKilometers)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.GPSPointDimension.ReadOnly =
    zio.aws.pinpoint.model.GPSPointDimension.wrap(buildAwsValue())
}
object GPSPointDimension {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.GPSPointDimension
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.GPSPointDimension =
      zio.aws.pinpoint.model.GPSPointDimension(
        coordinates.asEditable,
        rangeInKilometers.map(value => value)
      )
    def coordinates: zio.aws.pinpoint.model.GPSCoordinates.ReadOnly
    def rangeInKilometers: Option[__double]
    def getCoordinates
        : ZIO[Any, Nothing, zio.aws.pinpoint.model.GPSCoordinates.ReadOnly] =
      ZIO.succeed(coordinates)
    def getRangeInKilometers: ZIO[Any, AwsError, __double] =
      AwsError.unwrapOptionField("rangeInKilometers", rangeInKilometers)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.GPSPointDimension
  ) extends zio.aws.pinpoint.model.GPSPointDimension.ReadOnly {
    override val coordinates: zio.aws.pinpoint.model.GPSCoordinates.ReadOnly =
      zio.aws.pinpoint.model.GPSCoordinates.wrap(impl.coordinates())
    override val rangeInKilometers: Option[__double] = scala
      .Option(impl.rangeInKilometers())
      .map(value => zio.aws.pinpoint.model.primitives.__double(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.GPSPointDimension
  ): zio.aws.pinpoint.model.GPSPointDimension.ReadOnly = new Wrapper(impl)
}
