package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class GetApplicationSettingsRequest(applicationId: __string) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.GetApplicationSettingsRequest = {
    import GetApplicationSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.GetApplicationSettingsRequest
      .builder()
      .applicationId(__string.unwrap(applicationId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpoint.model.GetApplicationSettingsRequest.ReadOnly =
    zio.aws.pinpoint.model.GetApplicationSettingsRequest.wrap(buildAwsValue())
}
object GetApplicationSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.GetApplicationSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.GetApplicationSettingsRequest =
      zio.aws.pinpoint.model.GetApplicationSettingsRequest(applicationId)
    def applicationId: __string
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.GetApplicationSettingsRequest
  ) extends zio.aws.pinpoint.model.GetApplicationSettingsRequest.ReadOnly {
    override val applicationId: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.applicationId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.GetApplicationSettingsRequest
  ): zio.aws.pinpoint.model.GetApplicationSettingsRequest.ReadOnly =
    new Wrapper(impl)
}
