package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetAppsResponse(
    applicationsResponse: zio.aws.pinpoint.model.ApplicationsResponse
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.GetAppsResponse = {
    import GetAppsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.GetAppsResponse
      .builder()
      .applicationsResponse(applicationsResponse.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.GetAppsResponse.ReadOnly =
    zio.aws.pinpoint.model.GetAppsResponse.wrap(buildAwsValue())
}
object GetAppsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.GetAppsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.GetAppsResponse =
      zio.aws.pinpoint.model.GetAppsResponse(applicationsResponse.asEditable)
    def applicationsResponse
        : zio.aws.pinpoint.model.ApplicationsResponse.ReadOnly
    def getApplicationsResponse: ZIO[
      Any,
      Nothing,
      zio.aws.pinpoint.model.ApplicationsResponse.ReadOnly
    ] = ZIO.succeed(applicationsResponse)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.GetAppsResponse
  ) extends zio.aws.pinpoint.model.GetAppsResponse.ReadOnly {
    override val applicationsResponse
        : zio.aws.pinpoint.model.ApplicationsResponse.ReadOnly =
      zio.aws.pinpoint.model.ApplicationsResponse
        .wrap(impl.applicationsResponse())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.GetAppsResponse
  ): zio.aws.pinpoint.model.GetAppsResponse.ReadOnly = new Wrapper(impl)
}
