package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.{__timestampIso8601, __string}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class GetCampaignDateRangeKpiRequest(
    applicationId: __string,
    campaignId: __string,
    endTime: Option[__timestampIso8601] = None,
    kpiName: __string,
    nextToken: Option[__string] = None,
    pageSize: Option[__string] = None,
    startTime: Option[__timestampIso8601] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.GetCampaignDateRangeKpiRequest = {
    import GetCampaignDateRangeKpiRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.GetCampaignDateRangeKpiRequest
      .builder()
      .applicationId(__string.unwrap(applicationId): java.lang.String)
      .campaignId(__string.unwrap(campaignId): java.lang.String)
      .optionallyWith(
        endTime.map(value => __timestampIso8601.unwrap(value): Instant)
      )(_.endTime)
      .kpiName(__string.unwrap(kpiName): java.lang.String)
      .optionallyWith(
        nextToken.map(value => __string.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        pageSize.map(value => __string.unwrap(value): java.lang.String)
      )(_.pageSize)
      .optionallyWith(
        startTime.map(value => __timestampIso8601.unwrap(value): Instant)
      )(_.startTime)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpoint.model.GetCampaignDateRangeKpiRequest.ReadOnly =
    zio.aws.pinpoint.model.GetCampaignDateRangeKpiRequest.wrap(buildAwsValue())
}
object GetCampaignDateRangeKpiRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.GetCampaignDateRangeKpiRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.GetCampaignDateRangeKpiRequest =
      zio.aws.pinpoint.model.GetCampaignDateRangeKpiRequest(
        applicationId,
        campaignId,
        endTime.map(value => value),
        kpiName,
        nextToken.map(value => value),
        pageSize.map(value => value),
        startTime.map(value => value)
      )
    def applicationId: __string
    def campaignId: __string
    def endTime: Option[__timestampIso8601]
    def kpiName: __string
    def nextToken: Option[__string]
    def pageSize: Option[__string]
    def startTime: Option[__timestampIso8601]
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
    def getCampaignId: ZIO[Any, Nothing, __string] = ZIO.succeed(campaignId)
    def getEndTime: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getKpiName: ZIO[Any, Nothing, __string] = ZIO.succeed(kpiName)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getPageSize: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("pageSize", pageSize)
    def getStartTime: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("startTime", startTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.GetCampaignDateRangeKpiRequest
  ) extends zio.aws.pinpoint.model.GetCampaignDateRangeKpiRequest.ReadOnly {
    override val applicationId: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.applicationId())
    override val campaignId: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.campaignId())
    override val endTime: Option[__timestampIso8601] = scala
      .Option(impl.endTime())
      .map(value => zio.aws.pinpoint.model.primitives.__timestampIso8601(value))
    override val kpiName: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.kpiName())
    override val nextToken: Option[__string] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val pageSize: Option[__string] = scala
      .Option(impl.pageSize())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val startTime: Option[__timestampIso8601] = scala
      .Option(impl.startTime())
      .map(value => zio.aws.pinpoint.model.primitives.__timestampIso8601(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.GetCampaignDateRangeKpiRequest
  ): zio.aws.pinpoint.model.GetCampaignDateRangeKpiRequest.ReadOnly =
    new Wrapper(impl)
}
