package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class GetExportJobRequest(applicationId: __string, jobId: __string) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.GetExportJobRequest = {
    import GetExportJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.GetExportJobRequest
      .builder()
      .applicationId(__string.unwrap(applicationId): java.lang.String)
      .jobId(__string.unwrap(jobId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.GetExportJobRequest.ReadOnly =
    zio.aws.pinpoint.model.GetExportJobRequest.wrap(buildAwsValue())
}
object GetExportJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.GetExportJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.GetExportJobRequest =
      zio.aws.pinpoint.model.GetExportJobRequest(applicationId, jobId)
    def applicationId: __string
    def jobId: __string
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
    def getJobId: ZIO[Any, Nothing, __string] = ZIO.succeed(jobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.GetExportJobRequest
  ) extends zio.aws.pinpoint.model.GetExportJobRequest.ReadOnly {
    override val applicationId: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.applicationId())
    override val jobId: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.jobId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.GetExportJobRequest
  ): zio.aws.pinpoint.model.GetExportJobRequest.ReadOnly = new Wrapper(impl)
}
