package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class GetImportJobRequest(applicationId: __string, jobId: __string) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.GetImportJobRequest = {
    import GetImportJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.GetImportJobRequest
      .builder()
      .applicationId(__string.unwrap(applicationId): java.lang.String)
      .jobId(__string.unwrap(jobId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.GetImportJobRequest.ReadOnly =
    zio.aws.pinpoint.model.GetImportJobRequest.wrap(buildAwsValue())
}
object GetImportJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.GetImportJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.GetImportJobRequest =
      zio.aws.pinpoint.model.GetImportJobRequest(applicationId, jobId)
    def applicationId: __string
    def jobId: __string
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
    def getJobId: ZIO[Any, Nothing, __string] = ZIO.succeed(jobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.GetImportJobRequest
  ) extends zio.aws.pinpoint.model.GetImportJobRequest.ReadOnly {
    override val applicationId: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.applicationId())
    override val jobId: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.jobId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.GetImportJobRequest
  ): zio.aws.pinpoint.model.GetImportJobRequest.ReadOnly = new Wrapper(impl)
}
