package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class GetImportJobsRequest(
    applicationId: __string,
    pageSize: Option[__string] = None,
    token: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.GetImportJobsRequest = {
    import GetImportJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.GetImportJobsRequest
      .builder()
      .applicationId(__string.unwrap(applicationId): java.lang.String)
      .optionallyWith(
        pageSize.map(value => __string.unwrap(value): java.lang.String)
      )(_.pageSize)
      .optionallyWith(
        token.map(value => __string.unwrap(value): java.lang.String)
      )(_.token)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.GetImportJobsRequest.ReadOnly =
    zio.aws.pinpoint.model.GetImportJobsRequest.wrap(buildAwsValue())
}
object GetImportJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.GetImportJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.GetImportJobsRequest =
      zio.aws.pinpoint.model.GetImportJobsRequest(
        applicationId,
        pageSize.map(value => value),
        token.map(value => value)
      )
    def applicationId: __string
    def pageSize: Option[__string]
    def token: Option[__string]
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
    def getPageSize: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("pageSize", pageSize)
    def getToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("token", token)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.GetImportJobsRequest
  ) extends zio.aws.pinpoint.model.GetImportJobsRequest.ReadOnly {
    override val applicationId: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.applicationId())
    override val pageSize: Option[__string] = scala
      .Option(impl.pageSize())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val token: Option[__string] = scala
      .Option(impl.token())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.GetImportJobsRequest
  ): zio.aws.pinpoint.model.GetImportJobsRequest.ReadOnly = new Wrapper(impl)
}
