package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class GetJourneyExecutionActivityMetricsRequest(
    applicationId: __string,
    journeyActivityId: __string,
    journeyId: __string,
    nextToken: Option[__string] = None,
    pageSize: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.GetJourneyExecutionActivityMetricsRequest = {
    import GetJourneyExecutionActivityMetricsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.GetJourneyExecutionActivityMetricsRequest
      .builder()
      .applicationId(__string.unwrap(applicationId): java.lang.String)
      .journeyActivityId(__string.unwrap(journeyActivityId): java.lang.String)
      .journeyId(__string.unwrap(journeyId): java.lang.String)
      .optionallyWith(
        nextToken.map(value => __string.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        pageSize.map(value => __string.unwrap(value): java.lang.String)
      )(_.pageSize)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpoint.model.GetJourneyExecutionActivityMetricsRequest.ReadOnly =
    zio.aws.pinpoint.model.GetJourneyExecutionActivityMetricsRequest
      .wrap(buildAwsValue())
}
object GetJourneyExecutionActivityMetricsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.GetJourneyExecutionActivityMetricsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.pinpoint.model.GetJourneyExecutionActivityMetricsRequest =
      zio.aws.pinpoint.model.GetJourneyExecutionActivityMetricsRequest(
        applicationId,
        journeyActivityId,
        journeyId,
        nextToken.map(value => value),
        pageSize.map(value => value)
      )
    def applicationId: __string
    def journeyActivityId: __string
    def journeyId: __string
    def nextToken: Option[__string]
    def pageSize: Option[__string]
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
    def getJourneyActivityId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(journeyActivityId)
    def getJourneyId: ZIO[Any, Nothing, __string] = ZIO.succeed(journeyId)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getPageSize: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("pageSize", pageSize)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.GetJourneyExecutionActivityMetricsRequest
  ) extends zio.aws.pinpoint.model.GetJourneyExecutionActivityMetricsRequest.ReadOnly {
    override val applicationId: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.applicationId())
    override val journeyActivityId: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.journeyActivityId())
    override val journeyId: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.journeyId())
    override val nextToken: Option[__string] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val pageSize: Option[__string] = scala
      .Option(impl.pageSize())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.GetJourneyExecutionActivityMetricsRequest
  ): zio.aws.pinpoint.model.GetJourneyExecutionActivityMetricsRequest.ReadOnly =
    new Wrapper(impl)
}
