package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class GetJourneyExecutionMetricsRequest(
    applicationId: __string,
    journeyId: __string,
    nextToken: Option[__string] = None,
    pageSize: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.GetJourneyExecutionMetricsRequest = {
    import GetJourneyExecutionMetricsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.GetJourneyExecutionMetricsRequest
      .builder()
      .applicationId(__string.unwrap(applicationId): java.lang.String)
      .journeyId(__string.unwrap(journeyId): java.lang.String)
      .optionallyWith(
        nextToken.map(value => __string.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        pageSize.map(value => __string.unwrap(value): java.lang.String)
      )(_.pageSize)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpoint.model.GetJourneyExecutionMetricsRequest.ReadOnly =
    zio.aws.pinpoint.model.GetJourneyExecutionMetricsRequest
      .wrap(buildAwsValue())
}
object GetJourneyExecutionMetricsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.GetJourneyExecutionMetricsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.GetJourneyExecutionMetricsRequest =
      zio.aws.pinpoint.model.GetJourneyExecutionMetricsRequest(
        applicationId,
        journeyId,
        nextToken.map(value => value),
        pageSize.map(value => value)
      )
    def applicationId: __string
    def journeyId: __string
    def nextToken: Option[__string]
    def pageSize: Option[__string]
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
    def getJourneyId: ZIO[Any, Nothing, __string] = ZIO.succeed(journeyId)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getPageSize: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("pageSize", pageSize)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.GetJourneyExecutionMetricsRequest
  ) extends zio.aws.pinpoint.model.GetJourneyExecutionMetricsRequest.ReadOnly {
    override val applicationId: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.applicationId())
    override val journeyId: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.journeyId())
    override val nextToken: Option[__string] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val pageSize: Option[__string] = scala
      .Option(impl.pageSize())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.GetJourneyExecutionMetricsRequest
  ): zio.aws.pinpoint.model.GetJourneyExecutionMetricsRequest.ReadOnly =
    new Wrapper(impl)
}
