package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class GetPushTemplateRequest(
    templateName: __string,
    version: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.GetPushTemplateRequest = {
    import GetPushTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.GetPushTemplateRequest
      .builder()
      .templateName(__string.unwrap(templateName): java.lang.String)
      .optionallyWith(
        version.map(value => __string.unwrap(value): java.lang.String)
      )(_.version)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.GetPushTemplateRequest.ReadOnly =
    zio.aws.pinpoint.model.GetPushTemplateRequest.wrap(buildAwsValue())
}
object GetPushTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.GetPushTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.GetPushTemplateRequest =
      zio.aws.pinpoint.model
        .GetPushTemplateRequest(templateName, version.map(value => value))
    def templateName: __string
    def version: Option[__string]
    def getTemplateName: ZIO[Any, Nothing, __string] = ZIO.succeed(templateName)
    def getVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.GetPushTemplateRequest
  ) extends zio.aws.pinpoint.model.GetPushTemplateRequest.ReadOnly {
    override val templateName: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.templateName())
    override val version: Option[__string] = scala
      .Option(impl.version())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.GetPushTemplateRequest
  ): zio.aws.pinpoint.model.GetPushTemplateRequest.ReadOnly = new Wrapper(impl)
}
