package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class GetRecommenderConfigurationsRequest(
    pageSize: Option[__string] = None,
    token: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.GetRecommenderConfigurationsRequest = {
    import GetRecommenderConfigurationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.GetRecommenderConfigurationsRequest
      .builder()
      .optionallyWith(
        pageSize.map(value => __string.unwrap(value): java.lang.String)
      )(_.pageSize)
      .optionallyWith(
        token.map(value => __string.unwrap(value): java.lang.String)
      )(_.token)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpoint.model.GetRecommenderConfigurationsRequest.ReadOnly =
    zio.aws.pinpoint.model.GetRecommenderConfigurationsRequest
      .wrap(buildAwsValue())
}
object GetRecommenderConfigurationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.GetRecommenderConfigurationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.GetRecommenderConfigurationsRequest =
      zio.aws.pinpoint.model.GetRecommenderConfigurationsRequest(
        pageSize.map(value => value),
        token.map(value => value)
      )
    def pageSize: Option[__string]
    def token: Option[__string]
    def getPageSize: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("pageSize", pageSize)
    def getToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("token", token)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.GetRecommenderConfigurationsRequest
  ) extends zio.aws.pinpoint.model.GetRecommenderConfigurationsRequest.ReadOnly {
    override val pageSize: Option[__string] = scala
      .Option(impl.pageSize())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val token: Option[__string] = scala
      .Option(impl.token())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.GetRecommenderConfigurationsRequest
  ): zio.aws.pinpoint.model.GetRecommenderConfigurationsRequest.ReadOnly =
    new Wrapper(impl)
}
