package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class GetSegmentExportJobsRequest(
    applicationId: __string,
    pageSize: Option[__string] = None,
    segmentId: __string,
    token: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.GetSegmentExportJobsRequest = {
    import GetSegmentExportJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.GetSegmentExportJobsRequest
      .builder()
      .applicationId(__string.unwrap(applicationId): java.lang.String)
      .optionallyWith(
        pageSize.map(value => __string.unwrap(value): java.lang.String)
      )(_.pageSize)
      .segmentId(__string.unwrap(segmentId): java.lang.String)
      .optionallyWith(
        token.map(value => __string.unwrap(value): java.lang.String)
      )(_.token)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.GetSegmentExportJobsRequest.ReadOnly =
    zio.aws.pinpoint.model.GetSegmentExportJobsRequest.wrap(buildAwsValue())
}
object GetSegmentExportJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.GetSegmentExportJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.GetSegmentExportJobsRequest =
      zio.aws.pinpoint.model.GetSegmentExportJobsRequest(
        applicationId,
        pageSize.map(value => value),
        segmentId,
        token.map(value => value)
      )
    def applicationId: __string
    def pageSize: Option[__string]
    def segmentId: __string
    def token: Option[__string]
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
    def getPageSize: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("pageSize", pageSize)
    def getSegmentId: ZIO[Any, Nothing, __string] = ZIO.succeed(segmentId)
    def getToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("token", token)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.GetSegmentExportJobsRequest
  ) extends zio.aws.pinpoint.model.GetSegmentExportJobsRequest.ReadOnly {
    override val applicationId: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.applicationId())
    override val pageSize: Option[__string] = scala
      .Option(impl.pageSize())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val segmentId: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.segmentId())
    override val token: Option[__string] = scala
      .Option(impl.token())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.GetSegmentExportJobsRequest
  ): zio.aws.pinpoint.model.GetSegmentExportJobsRequest.ReadOnly = new Wrapper(
    impl
  )
}
