package zio.aws.pinpoint.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.{__integer, __string}
import scala.jdk.CollectionConverters.*
final case class HoldoutActivity(
    nextActivity: Option[__string] = None,
    percentage: __integer
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.HoldoutActivity = {
    import HoldoutActivity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.HoldoutActivity
      .builder()
      .optionallyWith(
        nextActivity.map(value => __string.unwrap(value): java.lang.String)
      )(_.nextActivity)
      .percentage(__integer.unwrap(percentage): Integer)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.HoldoutActivity.ReadOnly =
    zio.aws.pinpoint.model.HoldoutActivity.wrap(buildAwsValue())
}
object HoldoutActivity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.HoldoutActivity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.HoldoutActivity =
      zio.aws.pinpoint.model
        .HoldoutActivity(nextActivity.map(value => value), percentage)
    def nextActivity: Option[__string]
    def percentage: __integer
    def getNextActivity: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextActivity", nextActivity)
    def getPercentage: ZIO[Any, Nothing, __integer] = ZIO.succeed(percentage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.HoldoutActivity
  ) extends zio.aws.pinpoint.model.HoldoutActivity.ReadOnly {
    override val nextActivity: Option[__string] = scala
      .Option(impl.nextActivity())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val percentage: __integer =
      zio.aws.pinpoint.model.primitives.__integer(impl.percentage())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.HoldoutActivity
  ): zio.aws.pinpoint.model.HoldoutActivity.ReadOnly = new Wrapper(impl)
}
