package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.{__string, __boolean}
import scala.jdk.CollectionConverters.*
final case class ImportJobResource(
    defineSegment: Option[__boolean] = None,
    externalId: Option[__string] = None,
    format: zio.aws.pinpoint.model.Format,
    registerEndpoints: Option[__boolean] = None,
    roleArn: __string,
    s3Url: __string,
    segmentId: Option[__string] = None,
    segmentName: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.ImportJobResource = {
    import ImportJobResource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.ImportJobResource
      .builder()
      .optionallyWith(
        defineSegment.map(value => __boolean.unwrap(value): java.lang.Boolean)
      )(_.defineSegment)
      .optionallyWith(
        externalId.map(value => __string.unwrap(value): java.lang.String)
      )(_.externalId)
      .format(format.unwrap)
      .optionallyWith(
        registerEndpoints.map(value =>
          __boolean.unwrap(value): java.lang.Boolean
        )
      )(_.registerEndpoints)
      .roleArn(__string.unwrap(roleArn): java.lang.String)
      .s3Url(__string.unwrap(s3Url): java.lang.String)
      .optionallyWith(
        segmentId.map(value => __string.unwrap(value): java.lang.String)
      )(_.segmentId)
      .optionallyWith(
        segmentName.map(value => __string.unwrap(value): java.lang.String)
      )(_.segmentName)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.ImportJobResource.ReadOnly =
    zio.aws.pinpoint.model.ImportJobResource.wrap(buildAwsValue())
}
object ImportJobResource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.ImportJobResource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.ImportJobResource =
      zio.aws.pinpoint.model.ImportJobResource(
        defineSegment.map(value => value),
        externalId.map(value => value),
        format,
        registerEndpoints.map(value => value),
        roleArn,
        s3Url,
        segmentId.map(value => value),
        segmentName.map(value => value)
      )
    def defineSegment: Option[__boolean]
    def externalId: Option[__string]
    def format: zio.aws.pinpoint.model.Format
    def registerEndpoints: Option[__boolean]
    def roleArn: __string
    def s3Url: __string
    def segmentId: Option[__string]
    def segmentName: Option[__string]
    def getDefineSegment: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("defineSegment", defineSegment)
    def getExternalId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("externalId", externalId)
    def getFormat: ZIO[Any, Nothing, zio.aws.pinpoint.model.Format] =
      ZIO.succeed(format)
    def getRegisterEndpoints: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("registerEndpoints", registerEndpoints)
    def getRoleArn: ZIO[Any, Nothing, __string] = ZIO.succeed(roleArn)
    def getS3Url: ZIO[Any, Nothing, __string] = ZIO.succeed(s3Url)
    def getSegmentId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("segmentId", segmentId)
    def getSegmentName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("segmentName", segmentName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.ImportJobResource
  ) extends zio.aws.pinpoint.model.ImportJobResource.ReadOnly {
    override val defineSegment: Option[__boolean] = scala
      .Option(impl.defineSegment())
      .map(value => zio.aws.pinpoint.model.primitives.__boolean(value))
    override val externalId: Option[__string] = scala
      .Option(impl.externalId())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val format: zio.aws.pinpoint.model.Format =
      zio.aws.pinpoint.model.Format.wrap(impl.format())
    override val registerEndpoints: Option[__boolean] = scala
      .Option(impl.registerEndpoints())
      .map(value => zio.aws.pinpoint.model.primitives.__boolean(value))
    override val roleArn: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.roleArn())
    override val s3Url: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.s3Url())
    override val segmentId: Option[__string] = scala
      .Option(impl.segmentId())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val segmentName: Option[__string] = scala
      .Option(impl.segmentName())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.ImportJobResource
  ): zio.aws.pinpoint.model.ImportJobResource.ReadOnly = new Wrapper(impl)
}
