package zio.aws.pinpoint.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.{__integer, __string}
import scala.jdk.CollectionConverters.*
final case class ImportJobResponse(
    applicationId: __string,
    completedPieces: Option[__integer] = None,
    completionDate: Option[__string] = None,
    creationDate: __string,
    definition: zio.aws.pinpoint.model.ImportJobResource,
    failedPieces: Option[__integer] = None,
    failures: Option[Iterable[__string]] = None,
    id: __string,
    jobStatus: zio.aws.pinpoint.model.JobStatus,
    totalFailures: Option[__integer] = None,
    totalPieces: Option[__integer] = None,
    totalProcessed: Option[__integer] = None,
    `type`: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.ImportJobResponse = {
    import ImportJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.ImportJobResponse
      .builder()
      .applicationId(__string.unwrap(applicationId): java.lang.String)
      .optionallyWith(
        completedPieces.map(value => __integer.unwrap(value): Integer)
      )(_.completedPieces)
      .optionallyWith(
        completionDate.map(value => __string.unwrap(value): java.lang.String)
      )(_.completionDate)
      .creationDate(__string.unwrap(creationDate): java.lang.String)
      .definition(definition.buildAwsValue())
      .optionallyWith(
        failedPieces.map(value => __integer.unwrap(value): Integer)
      )(_.failedPieces)
      .optionallyWith(
        failures.map(value =>
          value.map { item =>
            __string.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.failures)
      .id(__string.unwrap(id): java.lang.String)
      .jobStatus(jobStatus.unwrap)
      .optionallyWith(
        totalFailures.map(value => __integer.unwrap(value): Integer)
      )(_.totalFailures)
      .optionallyWith(
        totalPieces.map(value => __integer.unwrap(value): Integer)
      )(_.totalPieces)
      .optionallyWith(
        totalProcessed.map(value => __integer.unwrap(value): Integer)
      )(_.totalProcessed)
      .`type`(__string.unwrap(`type`): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.ImportJobResponse.ReadOnly =
    zio.aws.pinpoint.model.ImportJobResponse.wrap(buildAwsValue())
}
object ImportJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.ImportJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.ImportJobResponse =
      zio.aws.pinpoint.model.ImportJobResponse(
        applicationId,
        completedPieces.map(value => value),
        completionDate.map(value => value),
        creationDate,
        definition.asEditable,
        failedPieces.map(value => value),
        failures.map(value => value),
        id,
        jobStatus,
        totalFailures.map(value => value),
        totalPieces.map(value => value),
        totalProcessed.map(value => value),
        `type`
      )
    def applicationId: __string
    def completedPieces: Option[__integer]
    def completionDate: Option[__string]
    def creationDate: __string
    def definition: zio.aws.pinpoint.model.ImportJobResource.ReadOnly
    def failedPieces: Option[__integer]
    def failures: Option[List[__string]]
    def id: __string
    def jobStatus: zio.aws.pinpoint.model.JobStatus
    def totalFailures: Option[__integer]
    def totalPieces: Option[__integer]
    def totalProcessed: Option[__integer]
    def `type`: __string
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
    def getCompletedPieces: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("completedPieces", completedPieces)
    def getCompletionDate: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("completionDate", completionDate)
    def getCreationDate: ZIO[Any, Nothing, __string] = ZIO.succeed(creationDate)
    def getDefinition
        : ZIO[Any, Nothing, zio.aws.pinpoint.model.ImportJobResource.ReadOnly] =
      ZIO.succeed(definition)
    def getFailedPieces: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("failedPieces", failedPieces)
    def getFailures: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("failures", failures)
    def getId: ZIO[Any, Nothing, __string] = ZIO.succeed(id)
    def getJobStatus: ZIO[Any, Nothing, zio.aws.pinpoint.model.JobStatus] =
      ZIO.succeed(jobStatus)
    def getTotalFailures: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("totalFailures", totalFailures)
    def getTotalPieces: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("totalPieces", totalPieces)
    def getTotalProcessed: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("totalProcessed", totalProcessed)
    def getType: ZIO[Any, Nothing, __string] = ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.ImportJobResponse
  ) extends zio.aws.pinpoint.model.ImportJobResponse.ReadOnly {
    override val applicationId: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.applicationId())
    override val completedPieces: Option[__integer] = scala
      .Option(impl.completedPieces())
      .map(value => zio.aws.pinpoint.model.primitives.__integer(value))
    override val completionDate: Option[__string] = scala
      .Option(impl.completionDate())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val creationDate: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.creationDate())
    override val definition: zio.aws.pinpoint.model.ImportJobResource.ReadOnly =
      zio.aws.pinpoint.model.ImportJobResource.wrap(impl.definition())
    override val failedPieces: Option[__integer] = scala
      .Option(impl.failedPieces())
      .map(value => zio.aws.pinpoint.model.primitives.__integer(value))
    override val failures: Option[List[__string]] = scala
      .Option(impl.failures())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.pinpoint.model.primitives.__string(item)
        }.toList
      )
    override val id: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.id())
    override val jobStatus: zio.aws.pinpoint.model.JobStatus =
      zio.aws.pinpoint.model.JobStatus.wrap(impl.jobStatus())
    override val totalFailures: Option[__integer] = scala
      .Option(impl.totalFailures())
      .map(value => zio.aws.pinpoint.model.primitives.__integer(value))
    override val totalPieces: Option[__integer] = scala
      .Option(impl.totalPieces())
      .map(value => zio.aws.pinpoint.model.primitives.__integer(value))
    override val totalProcessed: Option[__integer] = scala
      .Option(impl.totalProcessed())
      .map(value => zio.aws.pinpoint.model.primitives.__integer(value))
    override val `type`: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.ImportJobResponse
  ): zio.aws.pinpoint.model.ImportJobResponse.ReadOnly = new Wrapper(impl)
}
