package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class InAppCampaignSchedule(
    endDate: Option[__string] = None,
    eventFilter: Option[zio.aws.pinpoint.model.CampaignEventFilter] = None,
    quietTime: Option[zio.aws.pinpoint.model.QuietTime] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.InAppCampaignSchedule = {
    import InAppCampaignSchedule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.InAppCampaignSchedule
      .builder()
      .optionallyWith(
        endDate.map(value => __string.unwrap(value): java.lang.String)
      )(_.endDate)
      .optionallyWith(eventFilter.map(value => value.buildAwsValue()))(
        _.eventFilter
      )
      .optionallyWith(quietTime.map(value => value.buildAwsValue()))(
        _.quietTime
      )
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.InAppCampaignSchedule.ReadOnly =
    zio.aws.pinpoint.model.InAppCampaignSchedule.wrap(buildAwsValue())
}
object InAppCampaignSchedule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.InAppCampaignSchedule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.InAppCampaignSchedule =
      zio.aws.pinpoint.model.InAppCampaignSchedule(
        endDate.map(value => value),
        eventFilter.map(value => value.asEditable),
        quietTime.map(value => value.asEditable)
      )
    def endDate: Option[__string]
    def eventFilter: Option[zio.aws.pinpoint.model.CampaignEventFilter.ReadOnly]
    def quietTime: Option[zio.aws.pinpoint.model.QuietTime.ReadOnly]
    def getEndDate: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("endDate", endDate)
    def getEventFilter: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.CampaignEventFilter.ReadOnly
    ] = AwsError.unwrapOptionField("eventFilter", eventFilter)
    def getQuietTime
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.QuietTime.ReadOnly] =
      AwsError.unwrapOptionField("quietTime", quietTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.InAppCampaignSchedule
  ) extends zio.aws.pinpoint.model.InAppCampaignSchedule.ReadOnly {
    override val endDate: Option[__string] = scala
      .Option(impl.endDate())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val eventFilter
        : Option[zio.aws.pinpoint.model.CampaignEventFilter.ReadOnly] = scala
      .Option(impl.eventFilter())
      .map(value => zio.aws.pinpoint.model.CampaignEventFilter.wrap(value))
    override val quietTime: Option[zio.aws.pinpoint.model.QuietTime.ReadOnly] =
      scala
        .Option(impl.quietTime())
        .map(value => zio.aws.pinpoint.model.QuietTime.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.InAppCampaignSchedule
  ): zio.aws.pinpoint.model.InAppCampaignSchedule.ReadOnly = new Wrapper(impl)
}
