package zio.aws.pinpoint.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.{__integer, __string}
import scala.jdk.CollectionConverters.*
final case class InAppMessageCampaign(
    campaignId: Option[__string] = None,
    dailyCap: Option[__integer] = None,
    inAppMessage: Option[zio.aws.pinpoint.model.InAppMessage] = None,
    priority: Option[__integer] = None,
    schedule: Option[zio.aws.pinpoint.model.InAppCampaignSchedule] = None,
    sessionCap: Option[__integer] = None,
    totalCap: Option[__integer] = None,
    treatmentId: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.InAppMessageCampaign = {
    import InAppMessageCampaign.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.InAppMessageCampaign
      .builder()
      .optionallyWith(
        campaignId.map(value => __string.unwrap(value): java.lang.String)
      )(_.campaignId)
      .optionallyWith(dailyCap.map(value => __integer.unwrap(value): Integer))(
        _.dailyCap
      )
      .optionallyWith(inAppMessage.map(value => value.buildAwsValue()))(
        _.inAppMessage
      )
      .optionallyWith(priority.map(value => __integer.unwrap(value): Integer))(
        _.priority
      )
      .optionallyWith(schedule.map(value => value.buildAwsValue()))(_.schedule)
      .optionallyWith(
        sessionCap.map(value => __integer.unwrap(value): Integer)
      )(_.sessionCap)
      .optionallyWith(totalCap.map(value => __integer.unwrap(value): Integer))(
        _.totalCap
      )
      .optionallyWith(
        treatmentId.map(value => __string.unwrap(value): java.lang.String)
      )(_.treatmentId)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.InAppMessageCampaign.ReadOnly =
    zio.aws.pinpoint.model.InAppMessageCampaign.wrap(buildAwsValue())
}
object InAppMessageCampaign {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.InAppMessageCampaign
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.InAppMessageCampaign =
      zio.aws.pinpoint.model.InAppMessageCampaign(
        campaignId.map(value => value),
        dailyCap.map(value => value),
        inAppMessage.map(value => value.asEditable),
        priority.map(value => value),
        schedule.map(value => value.asEditable),
        sessionCap.map(value => value),
        totalCap.map(value => value),
        treatmentId.map(value => value)
      )
    def campaignId: Option[__string]
    def dailyCap: Option[__integer]
    def inAppMessage: Option[zio.aws.pinpoint.model.InAppMessage.ReadOnly]
    def priority: Option[__integer]
    def schedule: Option[zio.aws.pinpoint.model.InAppCampaignSchedule.ReadOnly]
    def sessionCap: Option[__integer]
    def totalCap: Option[__integer]
    def treatmentId: Option[__string]
    def getCampaignId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("campaignId", campaignId)
    def getDailyCap: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("dailyCap", dailyCap)
    def getInAppMessage
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.InAppMessage.ReadOnly] =
      AwsError.unwrapOptionField("inAppMessage", inAppMessage)
    def getPriority: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("priority", priority)
    def getSchedule: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.InAppCampaignSchedule.ReadOnly
    ] = AwsError.unwrapOptionField("schedule", schedule)
    def getSessionCap: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("sessionCap", sessionCap)
    def getTotalCap: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("totalCap", totalCap)
    def getTreatmentId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("treatmentId", treatmentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.InAppMessageCampaign
  ) extends zio.aws.pinpoint.model.InAppMessageCampaign.ReadOnly {
    override val campaignId: Option[__string] = scala
      .Option(impl.campaignId())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val dailyCap: Option[__integer] = scala
      .Option(impl.dailyCap())
      .map(value => zio.aws.pinpoint.model.primitives.__integer(value))
    override val inAppMessage
        : Option[zio.aws.pinpoint.model.InAppMessage.ReadOnly] = scala
      .Option(impl.inAppMessage())
      .map(value => zio.aws.pinpoint.model.InAppMessage.wrap(value))
    override val priority: Option[__integer] = scala
      .Option(impl.priority())
      .map(value => zio.aws.pinpoint.model.primitives.__integer(value))
    override val schedule
        : Option[zio.aws.pinpoint.model.InAppCampaignSchedule.ReadOnly] = scala
      .Option(impl.schedule())
      .map(value => zio.aws.pinpoint.model.InAppCampaignSchedule.wrap(value))
    override val sessionCap: Option[__integer] = scala
      .Option(impl.sessionCap())
      .map(value => zio.aws.pinpoint.model.primitives.__integer(value))
    override val totalCap: Option[__integer] = scala
      .Option(impl.totalCap())
      .map(value => zio.aws.pinpoint.model.primitives.__integer(value))
    override val treatmentId: Option[__string] = scala
      .Option(impl.treatmentId())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.InAppMessageCampaign
  ): zio.aws.pinpoint.model.InAppMessageCampaign.ReadOnly = new Wrapper(impl)
}
