package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class InAppMessageContent(
    backgroundColor: Option[__string] = None,
    bodyConfig: Option[zio.aws.pinpoint.model.InAppMessageBodyConfig] = None,
    headerConfig: Option[zio.aws.pinpoint.model.InAppMessageHeaderConfig] =
      None,
    imageUrl: Option[__string] = None,
    primaryBtn: Option[zio.aws.pinpoint.model.InAppMessageButton] = None,
    secondaryBtn: Option[zio.aws.pinpoint.model.InAppMessageButton] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.InAppMessageContent = {
    import InAppMessageContent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.InAppMessageContent
      .builder()
      .optionallyWith(
        backgroundColor.map(value => __string.unwrap(value): java.lang.String)
      )(_.backgroundColor)
      .optionallyWith(bodyConfig.map(value => value.buildAwsValue()))(
        _.bodyConfig
      )
      .optionallyWith(headerConfig.map(value => value.buildAwsValue()))(
        _.headerConfig
      )
      .optionallyWith(
        imageUrl.map(value => __string.unwrap(value): java.lang.String)
      )(_.imageUrl)
      .optionallyWith(primaryBtn.map(value => value.buildAwsValue()))(
        _.primaryBtn
      )
      .optionallyWith(secondaryBtn.map(value => value.buildAwsValue()))(
        _.secondaryBtn
      )
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.InAppMessageContent.ReadOnly =
    zio.aws.pinpoint.model.InAppMessageContent.wrap(buildAwsValue())
}
object InAppMessageContent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.InAppMessageContent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.InAppMessageContent =
      zio.aws.pinpoint.model.InAppMessageContent(
        backgroundColor.map(value => value),
        bodyConfig.map(value => value.asEditable),
        headerConfig.map(value => value.asEditable),
        imageUrl.map(value => value),
        primaryBtn.map(value => value.asEditable),
        secondaryBtn.map(value => value.asEditable)
      )
    def backgroundColor: Option[__string]
    def bodyConfig
        : Option[zio.aws.pinpoint.model.InAppMessageBodyConfig.ReadOnly]
    def headerConfig
        : Option[zio.aws.pinpoint.model.InAppMessageHeaderConfig.ReadOnly]
    def imageUrl: Option[__string]
    def primaryBtn: Option[zio.aws.pinpoint.model.InAppMessageButton.ReadOnly]
    def secondaryBtn: Option[zio.aws.pinpoint.model.InAppMessageButton.ReadOnly]
    def getBackgroundColor: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("backgroundColor", backgroundColor)
    def getBodyConfig: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.InAppMessageBodyConfig.ReadOnly
    ] = AwsError.unwrapOptionField("bodyConfig", bodyConfig)
    def getHeaderConfig: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.InAppMessageHeaderConfig.ReadOnly
    ] = AwsError.unwrapOptionField("headerConfig", headerConfig)
    def getImageUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("imageUrl", imageUrl)
    def getPrimaryBtn: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.InAppMessageButton.ReadOnly
    ] = AwsError.unwrapOptionField("primaryBtn", primaryBtn)
    def getSecondaryBtn: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.InAppMessageButton.ReadOnly
    ] = AwsError.unwrapOptionField("secondaryBtn", secondaryBtn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.InAppMessageContent
  ) extends zio.aws.pinpoint.model.InAppMessageContent.ReadOnly {
    override val backgroundColor: Option[__string] = scala
      .Option(impl.backgroundColor())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val bodyConfig
        : Option[zio.aws.pinpoint.model.InAppMessageBodyConfig.ReadOnly] = scala
      .Option(impl.bodyConfig())
      .map(value => zio.aws.pinpoint.model.InAppMessageBodyConfig.wrap(value))
    override val headerConfig
        : Option[zio.aws.pinpoint.model.InAppMessageHeaderConfig.ReadOnly] =
      scala
        .Option(impl.headerConfig())
        .map(value =>
          zio.aws.pinpoint.model.InAppMessageHeaderConfig.wrap(value)
        )
    override val imageUrl: Option[__string] = scala
      .Option(impl.imageUrl())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val primaryBtn
        : Option[zio.aws.pinpoint.model.InAppMessageButton.ReadOnly] = scala
      .Option(impl.primaryBtn())
      .map(value => zio.aws.pinpoint.model.InAppMessageButton.wrap(value))
    override val secondaryBtn
        : Option[zio.aws.pinpoint.model.InAppMessageButton.ReadOnly] = scala
      .Option(impl.secondaryBtn())
      .map(value => zio.aws.pinpoint.model.InAppMessageButton.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.InAppMessageContent
  ): zio.aws.pinpoint.model.InAppMessageContent.ReadOnly = new Wrapper(impl)
}
