package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class InAppMessageHeaderConfig(
    alignment: zio.aws.pinpoint.model.Alignment,
    header: __string,
    textColor: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.InAppMessageHeaderConfig = {
    import InAppMessageHeaderConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.InAppMessageHeaderConfig
      .builder()
      .alignment(alignment.unwrap)
      .header(__string.unwrap(header): java.lang.String)
      .textColor(__string.unwrap(textColor): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.InAppMessageHeaderConfig.ReadOnly =
    zio.aws.pinpoint.model.InAppMessageHeaderConfig.wrap(buildAwsValue())
}
object InAppMessageHeaderConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.InAppMessageHeaderConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.InAppMessageHeaderConfig =
      zio.aws.pinpoint.model
        .InAppMessageHeaderConfig(alignment, header, textColor)
    def alignment: zio.aws.pinpoint.model.Alignment
    def header: __string
    def textColor: __string
    def getAlignment: ZIO[Any, Nothing, zio.aws.pinpoint.model.Alignment] =
      ZIO.succeed(alignment)
    def getHeader: ZIO[Any, Nothing, __string] = ZIO.succeed(header)
    def getTextColor: ZIO[Any, Nothing, __string] = ZIO.succeed(textColor)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.InAppMessageHeaderConfig
  ) extends zio.aws.pinpoint.model.InAppMessageHeaderConfig.ReadOnly {
    override val alignment: zio.aws.pinpoint.model.Alignment =
      zio.aws.pinpoint.model.Alignment.wrap(impl.alignment())
    override val header: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.header())
    override val textColor: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.textColor())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.InAppMessageHeaderConfig
  ): zio.aws.pinpoint.model.InAppMessageHeaderConfig.ReadOnly = new Wrapper(
    impl
  )
}
