package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class InAppTemplateRequest(
    content: Option[Iterable[zio.aws.pinpoint.model.InAppMessageContent]] =
      None,
    customConfig: Option[Map[__string, __string]] = None,
    layout: Option[zio.aws.pinpoint.model.Layout] = None,
    tags: Option[Map[__string, __string]] = None,
    templateDescription: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.InAppTemplateRequest = {
    import InAppTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.InAppTemplateRequest
      .builder()
      .optionallyWith(
        content.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.content)
      .optionallyWith(
        customConfig.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> (__string.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.customConfig)
      .optionallyWith(layout.map(value => value.unwrap))(_.layout)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> (__string
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        templateDescription.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.templateDescription)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.InAppTemplateRequest.ReadOnly =
    zio.aws.pinpoint.model.InAppTemplateRequest.wrap(buildAwsValue())
}
object InAppTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.InAppTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.InAppTemplateRequest =
      zio.aws.pinpoint.model.InAppTemplateRequest(
        content.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        customConfig.map(value => value),
        layout.map(value => value),
        tags.map(value => value),
        templateDescription.map(value => value)
      )
    def content
        : Option[List[zio.aws.pinpoint.model.InAppMessageContent.ReadOnly]]
    def customConfig: Option[Map[__string, __string]]
    def layout: Option[zio.aws.pinpoint.model.Layout]
    def tags: Option[Map[__string, __string]]
    def templateDescription: Option[__string]
    def getContent: ZIO[Any, AwsError, List[
      zio.aws.pinpoint.model.InAppMessageContent.ReadOnly
    ]] = AwsError.unwrapOptionField("content", content)
    def getCustomConfig: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("customConfig", customConfig)
    def getLayout: ZIO[Any, AwsError, zio.aws.pinpoint.model.Layout] =
      AwsError.unwrapOptionField("layout", layout)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTemplateDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("templateDescription", templateDescription)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.InAppTemplateRequest
  ) extends zio.aws.pinpoint.model.InAppTemplateRequest.ReadOnly {
    override val content
        : Option[List[zio.aws.pinpoint.model.InAppMessageContent.ReadOnly]] =
      scala
        .Option(impl.content())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.pinpoint.model.InAppMessageContent.wrap(item)
          }.toList
        )
    override val customConfig: Option[Map[__string, __string]] = scala
      .Option(impl.customConfig())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.pinpoint.model.primitives.__string(
              key
            ) -> zio.aws.pinpoint.model.primitives.__string(value)
          })
          .toMap
      )
    override val layout: Option[zio.aws.pinpoint.model.Layout] = scala
      .Option(impl.layout())
      .map(value => zio.aws.pinpoint.model.Layout.wrap(value))
    override val tags: Option[Map[__string, __string]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.pinpoint.model.primitives.__string(
              key
            ) -> zio.aws.pinpoint.model.primitives.__string(value)
          })
          .toMap
      )
    override val templateDescription: Option[__string] = scala
      .Option(impl.templateDescription())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.InAppTemplateRequest
  ): zio.aws.pinpoint.model.InAppTemplateRequest.ReadOnly = new Wrapper(impl)
}
