package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class InAppTemplateResponse(
    arn: Option[__string] = None,
    content: Option[Iterable[zio.aws.pinpoint.model.InAppMessageContent]] =
      None,
    creationDate: __string,
    customConfig: Option[Map[__string, __string]] = None,
    lastModifiedDate: __string,
    layout: Option[zio.aws.pinpoint.model.Layout] = None,
    tags: Option[Map[__string, __string]] = None,
    templateDescription: Option[__string] = None,
    templateName: __string,
    templateType: zio.aws.pinpoint.model.TemplateType,
    version: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.InAppTemplateResponse = {
    import InAppTemplateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.InAppTemplateResponse
      .builder()
      .optionallyWith(
        arn.map(value => __string.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        content.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.content)
      .creationDate(__string.unwrap(creationDate): java.lang.String)
      .optionallyWith(
        customConfig.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> (__string.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.customConfig)
      .lastModifiedDate(__string.unwrap(lastModifiedDate): java.lang.String)
      .optionallyWith(layout.map(value => value.unwrap))(_.layout)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> (__string.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        templateDescription.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.templateDescription)
      .templateName(__string.unwrap(templateName): java.lang.String)
      .templateType(templateType.unwrap)
      .optionallyWith(
        version.map(value => __string.unwrap(value): java.lang.String)
      )(_.version)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.InAppTemplateResponse.ReadOnly =
    zio.aws.pinpoint.model.InAppTemplateResponse.wrap(buildAwsValue())
}
object InAppTemplateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.InAppTemplateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.InAppTemplateResponse =
      zio.aws.pinpoint.model.InAppTemplateResponse(
        arn.map(value => value),
        content.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        creationDate,
        customConfig.map(value => value),
        lastModifiedDate,
        layout.map(value => value),
        tags.map(value => value),
        templateDescription.map(value => value),
        templateName,
        templateType,
        version.map(value => value)
      )
    def arn: Option[__string]
    def content
        : Option[List[zio.aws.pinpoint.model.InAppMessageContent.ReadOnly]]
    def creationDate: __string
    def customConfig: Option[Map[__string, __string]]
    def lastModifiedDate: __string
    def layout: Option[zio.aws.pinpoint.model.Layout]
    def tags: Option[Map[__string, __string]]
    def templateDescription: Option[__string]
    def templateName: __string
    def templateType: zio.aws.pinpoint.model.TemplateType
    def version: Option[__string]
    def getArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("arn", arn)
    def getContent: ZIO[Any, AwsError, List[
      zio.aws.pinpoint.model.InAppMessageContent.ReadOnly
    ]] = AwsError.unwrapOptionField("content", content)
    def getCreationDate: ZIO[Any, Nothing, __string] = ZIO.succeed(creationDate)
    def getCustomConfig: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("customConfig", customConfig)
    def getLastModifiedDate: ZIO[Any, Nothing, __string] =
      ZIO.succeed(lastModifiedDate)
    def getLayout: ZIO[Any, AwsError, zio.aws.pinpoint.model.Layout] =
      AwsError.unwrapOptionField("layout", layout)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTemplateDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("templateDescription", templateDescription)
    def getTemplateName: ZIO[Any, Nothing, __string] = ZIO.succeed(templateName)
    def getTemplateType
        : ZIO[Any, Nothing, zio.aws.pinpoint.model.TemplateType] =
      ZIO.succeed(templateType)
    def getVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.InAppTemplateResponse
  ) extends zio.aws.pinpoint.model.InAppTemplateResponse.ReadOnly {
    override val arn: Option[__string] = scala
      .Option(impl.arn())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val content
        : Option[List[zio.aws.pinpoint.model.InAppMessageContent.ReadOnly]] =
      scala
        .Option(impl.content())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.pinpoint.model.InAppMessageContent.wrap(item)
          }.toList
        )
    override val creationDate: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.creationDate())
    override val customConfig: Option[Map[__string, __string]] = scala
      .Option(impl.customConfig())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.pinpoint.model.primitives.__string(
              key
            ) -> zio.aws.pinpoint.model.primitives.__string(value)
          })
          .toMap
      )
    override val lastModifiedDate: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.lastModifiedDate())
    override val layout: Option[zio.aws.pinpoint.model.Layout] = scala
      .Option(impl.layout())
      .map(value => zio.aws.pinpoint.model.Layout.wrap(value))
    override val tags: Option[Map[__string, __string]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.pinpoint.model.primitives.__string(
              key
            ) -> zio.aws.pinpoint.model.primitives.__string(value)
          })
          .toMap
      )
    override val templateDescription: Option[__string] = scala
      .Option(impl.templateDescription())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val templateName: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.templateName())
    override val templateType: zio.aws.pinpoint.model.TemplateType =
      zio.aws.pinpoint.model.TemplateType.wrap(impl.templateType())
    override val version: Option[__string] = scala
      .Option(impl.version())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.InAppTemplateResponse
  ): zio.aws.pinpoint.model.InAppTemplateResponse.ReadOnly = new Wrapper(impl)
}
