package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class ItemResponse(
    endpointItemResponse: Option[zio.aws.pinpoint.model.EndpointItemResponse] =
      None,
    eventsItemResponse: Option[
      Map[__string, zio.aws.pinpoint.model.EventItemResponse]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.ItemResponse = {
    import ItemResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.ItemResponse
      .builder()
      .optionallyWith(endpointItemResponse.map(value => value.buildAwsValue()))(
        _.endpointItemResponse
      )
      .optionallyWith(
        eventsItemResponse.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.eventsItemResponse)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.ItemResponse.ReadOnly =
    zio.aws.pinpoint.model.ItemResponse.wrap(buildAwsValue())
}
object ItemResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.ItemResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.ItemResponse =
      zio.aws.pinpoint.model.ItemResponse(
        endpointItemResponse.map(value => value.asEditable),
        eventsItemResponse.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def endpointItemResponse
        : Option[zio.aws.pinpoint.model.EndpointItemResponse.ReadOnly]
    def eventsItemResponse: Option[
      Map[__string, zio.aws.pinpoint.model.EventItemResponse.ReadOnly]
    ]
    def getEndpointItemResponse: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.EndpointItemResponse.ReadOnly
    ] = AwsError.unwrapOptionField("endpointItemResponse", endpointItemResponse)
    def getEventsItemResponse: ZIO[Any, AwsError, Map[
      __string,
      zio.aws.pinpoint.model.EventItemResponse.ReadOnly
    ]] = AwsError.unwrapOptionField("eventsItemResponse", eventsItemResponse)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.ItemResponse
  ) extends zio.aws.pinpoint.model.ItemResponse.ReadOnly {
    override val endpointItemResponse
        : Option[zio.aws.pinpoint.model.EndpointItemResponse.ReadOnly] = scala
      .Option(impl.endpointItemResponse())
      .map(value => zio.aws.pinpoint.model.EndpointItemResponse.wrap(value))
    override val eventsItemResponse: Option[
      Map[__string, zio.aws.pinpoint.model.EventItemResponse.ReadOnly]
    ] = scala
      .Option(impl.eventsItemResponse())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.pinpoint.model.primitives.__string(
              key
            ) -> zio.aws.pinpoint.model.EventItemResponse.wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.ItemResponse
  ): zio.aws.pinpoint.model.ItemResponse.ReadOnly = new Wrapper(impl)
}
