package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class JourneyChannelSettings(
    connectCampaignArn: Option[__string] = None,
    connectCampaignExecutionRoleArn: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.JourneyChannelSettings = {
    import JourneyChannelSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.JourneyChannelSettings
      .builder()
      .optionallyWith(
        connectCampaignArn.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.connectCampaignArn)
      .optionallyWith(
        connectCampaignExecutionRoleArn.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.connectCampaignExecutionRoleArn)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.JourneyChannelSettings.ReadOnly =
    zio.aws.pinpoint.model.JourneyChannelSettings.wrap(buildAwsValue())
}
object JourneyChannelSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.JourneyChannelSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.JourneyChannelSettings =
      zio.aws.pinpoint.model.JourneyChannelSettings(
        connectCampaignArn.map(value => value),
        connectCampaignExecutionRoleArn.map(value => value)
      )
    def connectCampaignArn: Option[__string]
    def connectCampaignExecutionRoleArn: Option[__string]
    def getConnectCampaignArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("connectCampaignArn", connectCampaignArn)
    def getConnectCampaignExecutionRoleArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField(
        "connectCampaignExecutionRoleArn",
        connectCampaignExecutionRoleArn
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.JourneyChannelSettings
  ) extends zio.aws.pinpoint.model.JourneyChannelSettings.ReadOnly {
    override val connectCampaignArn: Option[__string] = scala
      .Option(impl.connectCampaignArn())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val connectCampaignExecutionRoleArn: Option[__string] = scala
      .Option(impl.connectCampaignExecutionRoleArn())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.JourneyChannelSettings
  ): zio.aws.pinpoint.model.JourneyChannelSettings.ReadOnly = new Wrapper(impl)
}
