package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.{__timestampIso8601, __string}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class JourneyDateRangeKpiResponse(
    applicationId: __string,
    endTime: __timestampIso8601,
    journeyId: __string,
    kpiName: __string,
    kpiResult: zio.aws.pinpoint.model.BaseKpiResult,
    nextToken: Option[__string] = None,
    startTime: __timestampIso8601
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.JourneyDateRangeKpiResponse = {
    import JourneyDateRangeKpiResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.JourneyDateRangeKpiResponse
      .builder()
      .applicationId(__string.unwrap(applicationId): java.lang.String)
      .endTime(__timestampIso8601.unwrap(endTime): Instant)
      .journeyId(__string.unwrap(journeyId): java.lang.String)
      .kpiName(__string.unwrap(kpiName): java.lang.String)
      .kpiResult(kpiResult.buildAwsValue())
      .optionallyWith(
        nextToken.map(value => __string.unwrap(value): java.lang.String)
      )(_.nextToken)
      .startTime(__timestampIso8601.unwrap(startTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.JourneyDateRangeKpiResponse.ReadOnly =
    zio.aws.pinpoint.model.JourneyDateRangeKpiResponse.wrap(buildAwsValue())
}
object JourneyDateRangeKpiResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.JourneyDateRangeKpiResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.JourneyDateRangeKpiResponse =
      zio.aws.pinpoint.model.JourneyDateRangeKpiResponse(
        applicationId,
        endTime,
        journeyId,
        kpiName,
        kpiResult.asEditable,
        nextToken.map(value => value),
        startTime
      )
    def applicationId: __string
    def endTime: __timestampIso8601
    def journeyId: __string
    def kpiName: __string
    def kpiResult: zio.aws.pinpoint.model.BaseKpiResult.ReadOnly
    def nextToken: Option[__string]
    def startTime: __timestampIso8601
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
    def getEndTime: ZIO[Any, Nothing, __timestampIso8601] = ZIO.succeed(endTime)
    def getJourneyId: ZIO[Any, Nothing, __string] = ZIO.succeed(journeyId)
    def getKpiName: ZIO[Any, Nothing, __string] = ZIO.succeed(kpiName)
    def getKpiResult
        : ZIO[Any, Nothing, zio.aws.pinpoint.model.BaseKpiResult.ReadOnly] =
      ZIO.succeed(kpiResult)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getStartTime: ZIO[Any, Nothing, __timestampIso8601] =
      ZIO.succeed(startTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.JourneyDateRangeKpiResponse
  ) extends zio.aws.pinpoint.model.JourneyDateRangeKpiResponse.ReadOnly {
    override val applicationId: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.applicationId())
    override val endTime: __timestampIso8601 =
      zio.aws.pinpoint.model.primitives.__timestampIso8601(impl.endTime())
    override val journeyId: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.journeyId())
    override val kpiName: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.kpiName())
    override val kpiResult: zio.aws.pinpoint.model.BaseKpiResult.ReadOnly =
      zio.aws.pinpoint.model.BaseKpiResult.wrap(impl.kpiResult())
    override val nextToken: Option[__string] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val startTime: __timestampIso8601 =
      zio.aws.pinpoint.model.primitives.__timestampIso8601(impl.startTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.JourneyDateRangeKpiResponse
  ): zio.aws.pinpoint.model.JourneyDateRangeKpiResponse.ReadOnly = new Wrapper(
    impl
  )
}
