package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class JourneyEmailMessage(fromAddress: Option[__string] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.JourneyEmailMessage = {
    import JourneyEmailMessage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.JourneyEmailMessage
      .builder()
      .optionallyWith(
        fromAddress.map(value => __string.unwrap(value): java.lang.String)
      )(_.fromAddress)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.JourneyEmailMessage.ReadOnly =
    zio.aws.pinpoint.model.JourneyEmailMessage.wrap(buildAwsValue())
}
object JourneyEmailMessage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.JourneyEmailMessage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.JourneyEmailMessage =
      zio.aws.pinpoint.model
        .JourneyEmailMessage(fromAddress.map(value => value))
    def fromAddress: Option[__string]
    def getFromAddress: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("fromAddress", fromAddress)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.JourneyEmailMessage
  ) extends zio.aws.pinpoint.model.JourneyEmailMessage.ReadOnly {
    override val fromAddress: Option[__string] = scala
      .Option(impl.fromAddress())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.JourneyEmailMessage
  ): zio.aws.pinpoint.model.JourneyEmailMessage.ReadOnly = new Wrapper(impl)
}
