package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class JourneyExecutionActivityMetricsResponse(
    activityType: __string,
    applicationId: __string,
    journeyActivityId: __string,
    journeyId: __string,
    lastEvaluatedTime: __string,
    metrics: Map[__string, __string]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.JourneyExecutionActivityMetricsResponse = {
    import JourneyExecutionActivityMetricsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.JourneyExecutionActivityMetricsResponse
      .builder()
      .activityType(__string.unwrap(activityType): java.lang.String)
      .applicationId(__string.unwrap(applicationId): java.lang.String)
      .journeyActivityId(__string.unwrap(journeyActivityId): java.lang.String)
      .journeyId(__string.unwrap(journeyId): java.lang.String)
      .lastEvaluatedTime(__string.unwrap(lastEvaluatedTime): java.lang.String)
      .metrics(
        metrics
          .map({ case (key, value) =>
            (__string.unwrap(key): java.lang.String) -> (__string
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly
      : zio.aws.pinpoint.model.JourneyExecutionActivityMetricsResponse.ReadOnly =
    zio.aws.pinpoint.model.JourneyExecutionActivityMetricsResponse
      .wrap(buildAwsValue())
}
object JourneyExecutionActivityMetricsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.JourneyExecutionActivityMetricsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.pinpoint.model.JourneyExecutionActivityMetricsResponse =
      zio.aws.pinpoint.model.JourneyExecutionActivityMetricsResponse(
        activityType,
        applicationId,
        journeyActivityId,
        journeyId,
        lastEvaluatedTime,
        metrics
      )
    def activityType: __string
    def applicationId: __string
    def journeyActivityId: __string
    def journeyId: __string
    def lastEvaluatedTime: __string
    def metrics: Map[__string, __string]
    def getActivityType: ZIO[Any, Nothing, __string] = ZIO.succeed(activityType)
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
    def getJourneyActivityId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(journeyActivityId)
    def getJourneyId: ZIO[Any, Nothing, __string] = ZIO.succeed(journeyId)
    def getLastEvaluatedTime: ZIO[Any, Nothing, __string] =
      ZIO.succeed(lastEvaluatedTime)
    def getMetrics: ZIO[Any, Nothing, Map[__string, __string]] =
      ZIO.succeed(metrics)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.JourneyExecutionActivityMetricsResponse
  ) extends zio.aws.pinpoint.model.JourneyExecutionActivityMetricsResponse.ReadOnly {
    override val activityType: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.activityType())
    override val applicationId: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.applicationId())
    override val journeyActivityId: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.journeyActivityId())
    override val journeyId: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.journeyId())
    override val lastEvaluatedTime: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.lastEvaluatedTime())
    override val metrics: Map[__string, __string] = impl
      .metrics()
      .asScala
      .map({ case (key, value) =>
        zio.aws.pinpoint.model.primitives
          .__string(key) -> zio.aws.pinpoint.model.primitives.__string(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.JourneyExecutionActivityMetricsResponse
  ): zio.aws.pinpoint.model.JourneyExecutionActivityMetricsResponse.ReadOnly =
    new Wrapper(impl)
}
