package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class JourneyExecutionMetricsResponse(
    applicationId: __string,
    journeyId: __string,
    lastEvaluatedTime: __string,
    metrics: Map[__string, __string]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.JourneyExecutionMetricsResponse = {
    import JourneyExecutionMetricsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.JourneyExecutionMetricsResponse
      .builder()
      .applicationId(__string.unwrap(applicationId): java.lang.String)
      .journeyId(__string.unwrap(journeyId): java.lang.String)
      .lastEvaluatedTime(__string.unwrap(lastEvaluatedTime): java.lang.String)
      .metrics(
        metrics
          .map({ case (key, value) =>
            (__string.unwrap(key): java.lang.String) -> (__string
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly
      : zio.aws.pinpoint.model.JourneyExecutionMetricsResponse.ReadOnly =
    zio.aws.pinpoint.model.JourneyExecutionMetricsResponse.wrap(buildAwsValue())
}
object JourneyExecutionMetricsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.JourneyExecutionMetricsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.JourneyExecutionMetricsResponse =
      zio.aws.pinpoint.model.JourneyExecutionMetricsResponse(
        applicationId,
        journeyId,
        lastEvaluatedTime,
        metrics
      )
    def applicationId: __string
    def journeyId: __string
    def lastEvaluatedTime: __string
    def metrics: Map[__string, __string]
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
    def getJourneyId: ZIO[Any, Nothing, __string] = ZIO.succeed(journeyId)
    def getLastEvaluatedTime: ZIO[Any, Nothing, __string] =
      ZIO.succeed(lastEvaluatedTime)
    def getMetrics: ZIO[Any, Nothing, Map[__string, __string]] =
      ZIO.succeed(metrics)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.JourneyExecutionMetricsResponse
  ) extends zio.aws.pinpoint.model.JourneyExecutionMetricsResponse.ReadOnly {
    override val applicationId: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.applicationId())
    override val journeyId: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.journeyId())
    override val lastEvaluatedTime: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.lastEvaluatedTime())
    override val metrics: Map[__string, __string] = impl
      .metrics()
      .asScala
      .map({ case (key, value) =>
        zio.aws.pinpoint.model.primitives
          .__string(key) -> zio.aws.pinpoint.model.primitives.__string(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.JourneyExecutionMetricsResponse
  ): zio.aws.pinpoint.model.JourneyExecutionMetricsResponse.ReadOnly =
    new Wrapper(impl)
}
