package zio.aws.pinpoint.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.{__string, __integer}
import scala.jdk.CollectionConverters.*
final case class JourneyLimits(
    dailyCap: Option[__integer] = None,
    endpointReentryCap: Option[__integer] = None,
    messagesPerSecond: Option[__integer] = None,
    endpointReentryInterval: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.JourneyLimits = {
    import JourneyLimits.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.JourneyLimits
      .builder()
      .optionallyWith(dailyCap.map(value => __integer.unwrap(value): Integer))(
        _.dailyCap
      )
      .optionallyWith(
        endpointReentryCap.map(value => __integer.unwrap(value): Integer)
      )(_.endpointReentryCap)
      .optionallyWith(
        messagesPerSecond.map(value => __integer.unwrap(value): Integer)
      )(_.messagesPerSecond)
      .optionallyWith(
        endpointReentryInterval.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.endpointReentryInterval)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.JourneyLimits.ReadOnly =
    zio.aws.pinpoint.model.JourneyLimits.wrap(buildAwsValue())
}
object JourneyLimits {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.JourneyLimits
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.JourneyLimits =
      zio.aws.pinpoint.model.JourneyLimits(
        dailyCap.map(value => value),
        endpointReentryCap.map(value => value),
        messagesPerSecond.map(value => value),
        endpointReentryInterval.map(value => value)
      )
    def dailyCap: Option[__integer]
    def endpointReentryCap: Option[__integer]
    def messagesPerSecond: Option[__integer]
    def endpointReentryInterval: Option[__string]
    def getDailyCap: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("dailyCap", dailyCap)
    def getEndpointReentryCap: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("endpointReentryCap", endpointReentryCap)
    def getMessagesPerSecond: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("messagesPerSecond", messagesPerSecond)
    def getEndpointReentryInterval: ZIO[Any, AwsError, __string] = AwsError
      .unwrapOptionField("endpointReentryInterval", endpointReentryInterval)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.JourneyLimits
  ) extends zio.aws.pinpoint.model.JourneyLimits.ReadOnly {
    override val dailyCap: Option[__integer] = scala
      .Option(impl.dailyCap())
      .map(value => zio.aws.pinpoint.model.primitives.__integer(value))
    override val endpointReentryCap: Option[__integer] = scala
      .Option(impl.endpointReentryCap())
      .map(value => zio.aws.pinpoint.model.primitives.__integer(value))
    override val messagesPerSecond: Option[__integer] = scala
      .Option(impl.messagesPerSecond())
      .map(value => zio.aws.pinpoint.model.primitives.__integer(value))
    override val endpointReentryInterval: Option[__string] = scala
      .Option(impl.endpointReentryInterval())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.JourneyLimits
  ): zio.aws.pinpoint.model.JourneyLimits.ReadOnly = new Wrapper(impl)
}
