package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.{__boolean, __string}
import scala.jdk.CollectionConverters.*
final case class JourneyResponse(
    activities: Option[Map[__string, zio.aws.pinpoint.model.Activity]] = None,
    applicationId: __string,
    creationDate: Option[__string] = None,
    id: __string,
    lastModifiedDate: Option[__string] = None,
    limits: Option[zio.aws.pinpoint.model.JourneyLimits] = None,
    localTime: Option[__boolean] = None,
    name: __string,
    quietTime: Option[zio.aws.pinpoint.model.QuietTime] = None,
    refreshFrequency: Option[__string] = None,
    schedule: Option[zio.aws.pinpoint.model.JourneySchedule] = None,
    startActivity: Option[__string] = None,
    startCondition: Option[zio.aws.pinpoint.model.StartCondition] = None,
    state: Option[zio.aws.pinpoint.model.State] = None,
    tags: Option[Map[__string, __string]] = None,
    waitForQuietTime: Option[__boolean] = None,
    refreshOnSegmentUpdate: Option[__boolean] = None,
    journeyChannelSettings: Option[
      zio.aws.pinpoint.model.JourneyChannelSettings
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.JourneyResponse = {
    import JourneyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.JourneyResponse
      .builder()
      .optionallyWith(
        activities.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.activities)
      .applicationId(__string.unwrap(applicationId): java.lang.String)
      .optionallyWith(
        creationDate.map(value => __string.unwrap(value): java.lang.String)
      )(_.creationDate)
      .id(__string.unwrap(id): java.lang.String)
      .optionallyWith(
        lastModifiedDate.map(value => __string.unwrap(value): java.lang.String)
      )(_.lastModifiedDate)
      .optionallyWith(limits.map(value => value.buildAwsValue()))(_.limits)
      .optionallyWith(
        localTime.map(value => __boolean.unwrap(value): java.lang.Boolean)
      )(_.localTime)
      .name(__string.unwrap(name): java.lang.String)
      .optionallyWith(quietTime.map(value => value.buildAwsValue()))(
        _.quietTime
      )
      .optionallyWith(
        refreshFrequency.map(value => __string.unwrap(value): java.lang.String)
      )(_.refreshFrequency)
      .optionallyWith(schedule.map(value => value.buildAwsValue()))(_.schedule)
      .optionallyWith(
        startActivity.map(value => __string.unwrap(value): java.lang.String)
      )(_.startActivity)
      .optionallyWith(startCondition.map(value => value.buildAwsValue()))(
        _.startCondition
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> (__string.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        waitForQuietTime.map(value =>
          __boolean.unwrap(value): java.lang.Boolean
        )
      )(_.waitForQuietTime)
      .optionallyWith(
        refreshOnSegmentUpdate.map(value =>
          __boolean.unwrap(value): java.lang.Boolean
        )
      )(_.refreshOnSegmentUpdate)
      .optionallyWith(
        journeyChannelSettings.map(value => value.buildAwsValue())
      )(_.journeyChannelSettings)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.JourneyResponse.ReadOnly =
    zio.aws.pinpoint.model.JourneyResponse.wrap(buildAwsValue())
}
object JourneyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.JourneyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.JourneyResponse =
      zio.aws.pinpoint.model.JourneyResponse(
        activities.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        applicationId,
        creationDate.map(value => value),
        id,
        lastModifiedDate.map(value => value),
        limits.map(value => value.asEditable),
        localTime.map(value => value),
        name,
        quietTime.map(value => value.asEditable),
        refreshFrequency.map(value => value),
        schedule.map(value => value.asEditable),
        startActivity.map(value => value),
        startCondition.map(value => value.asEditable),
        state.map(value => value),
        tags.map(value => value),
        waitForQuietTime.map(value => value),
        refreshOnSegmentUpdate.map(value => value),
        journeyChannelSettings.map(value => value.asEditable)
      )
    def activities
        : Option[Map[__string, zio.aws.pinpoint.model.Activity.ReadOnly]]
    def applicationId: __string
    def creationDate: Option[__string]
    def id: __string
    def lastModifiedDate: Option[__string]
    def limits: Option[zio.aws.pinpoint.model.JourneyLimits.ReadOnly]
    def localTime: Option[__boolean]
    def name: __string
    def quietTime: Option[zio.aws.pinpoint.model.QuietTime.ReadOnly]
    def refreshFrequency: Option[__string]
    def schedule: Option[zio.aws.pinpoint.model.JourneySchedule.ReadOnly]
    def startActivity: Option[__string]
    def startCondition: Option[zio.aws.pinpoint.model.StartCondition.ReadOnly]
    def state: Option[zio.aws.pinpoint.model.State]
    def tags: Option[Map[__string, __string]]
    def waitForQuietTime: Option[__boolean]
    def refreshOnSegmentUpdate: Option[__boolean]
    def journeyChannelSettings
        : Option[zio.aws.pinpoint.model.JourneyChannelSettings.ReadOnly]
    def getActivities: ZIO[Any, AwsError, Map[
      __string,
      zio.aws.pinpoint.model.Activity.ReadOnly
    ]] = AwsError.unwrapOptionField("activities", activities)
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
    def getCreationDate: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getId: ZIO[Any, Nothing, __string] = ZIO.succeed(id)
    def getLastModifiedDate: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getLimits
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.JourneyLimits.ReadOnly] =
      AwsError.unwrapOptionField("limits", limits)
    def getLocalTime: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("localTime", localTime)
    def getName: ZIO[Any, Nothing, __string] = ZIO.succeed(name)
    def getQuietTime
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.QuietTime.ReadOnly] =
      AwsError.unwrapOptionField("quietTime", quietTime)
    def getRefreshFrequency: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("refreshFrequency", refreshFrequency)
    def getSchedule
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.JourneySchedule.ReadOnly] =
      AwsError.unwrapOptionField("schedule", schedule)
    def getStartActivity: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("startActivity", startActivity)
    def getStartCondition
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.StartCondition.ReadOnly] =
      AwsError.unwrapOptionField("startCondition", startCondition)
    def getState: ZIO[Any, AwsError, zio.aws.pinpoint.model.State] =
      AwsError.unwrapOptionField("state", state)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
    def getWaitForQuietTime: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("waitForQuietTime", waitForQuietTime)
    def getRefreshOnSegmentUpdate: ZIO[Any, AwsError, __boolean] = AwsError
      .unwrapOptionField("refreshOnSegmentUpdate", refreshOnSegmentUpdate)
    def getJourneyChannelSettings: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.JourneyChannelSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "journeyChannelSettings",
      journeyChannelSettings
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.JourneyResponse
  ) extends zio.aws.pinpoint.model.JourneyResponse.ReadOnly {
    override val activities
        : Option[Map[__string, zio.aws.pinpoint.model.Activity.ReadOnly]] =
      scala
        .Option(impl.activities())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.pinpoint.model.primitives
                .__string(key) -> zio.aws.pinpoint.model.Activity.wrap(value)
            })
            .toMap
        )
    override val applicationId: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.applicationId())
    override val creationDate: Option[__string] = scala
      .Option(impl.creationDate())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val id: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.id())
    override val lastModifiedDate: Option[__string] = scala
      .Option(impl.lastModifiedDate())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val limits: Option[zio.aws.pinpoint.model.JourneyLimits.ReadOnly] =
      scala
        .Option(impl.limits())
        .map(value => zio.aws.pinpoint.model.JourneyLimits.wrap(value))
    override val localTime: Option[__boolean] = scala
      .Option(impl.localTime())
      .map(value => zio.aws.pinpoint.model.primitives.__boolean(value))
    override val name: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.name())
    override val quietTime: Option[zio.aws.pinpoint.model.QuietTime.ReadOnly] =
      scala
        .Option(impl.quietTime())
        .map(value => zio.aws.pinpoint.model.QuietTime.wrap(value))
    override val refreshFrequency: Option[__string] = scala
      .Option(impl.refreshFrequency())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val schedule
        : Option[zio.aws.pinpoint.model.JourneySchedule.ReadOnly] = scala
      .Option(impl.schedule())
      .map(value => zio.aws.pinpoint.model.JourneySchedule.wrap(value))
    override val startActivity: Option[__string] = scala
      .Option(impl.startActivity())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val startCondition
        : Option[zio.aws.pinpoint.model.StartCondition.ReadOnly] = scala
      .Option(impl.startCondition())
      .map(value => zio.aws.pinpoint.model.StartCondition.wrap(value))
    override val state: Option[zio.aws.pinpoint.model.State] = scala
      .Option(impl.state())
      .map(value => zio.aws.pinpoint.model.State.wrap(value))
    override val tags: Option[Map[__string, __string]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.pinpoint.model.primitives.__string(
              key
            ) -> zio.aws.pinpoint.model.primitives.__string(value)
          })
          .toMap
      )
    override val waitForQuietTime: Option[__boolean] = scala
      .Option(impl.waitForQuietTime())
      .map(value => zio.aws.pinpoint.model.primitives.__boolean(value))
    override val refreshOnSegmentUpdate: Option[__boolean] = scala
      .Option(impl.refreshOnSegmentUpdate())
      .map(value => zio.aws.pinpoint.model.primitives.__boolean(value))
    override val journeyChannelSettings
        : Option[zio.aws.pinpoint.model.JourneyChannelSettings.ReadOnly] = scala
      .Option(impl.journeyChannelSettings())
      .map(value => zio.aws.pinpoint.model.JourneyChannelSettings.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.JourneyResponse
  ): zio.aws.pinpoint.model.JourneyResponse.ReadOnly = new Wrapper(impl)
}
