package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.{__string, __timestampIso8601}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class JourneySchedule(
    endTime: Option[__timestampIso8601] = None,
    startTime: Option[__timestampIso8601] = None,
    timezone: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.JourneySchedule = {
    import JourneySchedule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.JourneySchedule
      .builder()
      .optionallyWith(
        endTime.map(value => __timestampIso8601.unwrap(value): Instant)
      )(_.endTime)
      .optionallyWith(
        startTime.map(value => __timestampIso8601.unwrap(value): Instant)
      )(_.startTime)
      .optionallyWith(
        timezone.map(value => __string.unwrap(value): java.lang.String)
      )(_.timezone)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.JourneySchedule.ReadOnly =
    zio.aws.pinpoint.model.JourneySchedule.wrap(buildAwsValue())
}
object JourneySchedule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.JourneySchedule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.JourneySchedule =
      zio.aws.pinpoint.model.JourneySchedule(
        endTime.map(value => value),
        startTime.map(value => value),
        timezone.map(value => value)
      )
    def endTime: Option[__timestampIso8601]
    def startTime: Option[__timestampIso8601]
    def timezone: Option[__string]
    def getEndTime: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getStartTime: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getTimezone: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("timezone", timezone)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.JourneySchedule
  ) extends zio.aws.pinpoint.model.JourneySchedule.ReadOnly {
    override val endTime: Option[__timestampIso8601] = scala
      .Option(impl.endTime())
      .map(value => zio.aws.pinpoint.model.primitives.__timestampIso8601(value))
    override val startTime: Option[__timestampIso8601] = scala
      .Option(impl.startTime())
      .map(value => zio.aws.pinpoint.model.primitives.__timestampIso8601(value))
    override val timezone: Option[__string] = scala
      .Option(impl.timezone())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.JourneySchedule
  ): zio.aws.pinpoint.model.JourneySchedule.ReadOnly = new Wrapper(impl)
}
