package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class ListRecommenderConfigurationsResponse(
    item: Iterable[zio.aws.pinpoint.model.RecommenderConfigurationResponse],
    nextToken: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.ListRecommenderConfigurationsResponse = {
    import ListRecommenderConfigurationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.ListRecommenderConfigurationsResponse
      .builder()
      .item(item.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => __string.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpoint.model.ListRecommenderConfigurationsResponse.ReadOnly =
    zio.aws.pinpoint.model.ListRecommenderConfigurationsResponse
      .wrap(buildAwsValue())
}
object ListRecommenderConfigurationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.ListRecommenderConfigurationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.pinpoint.model.ListRecommenderConfigurationsResponse =
      zio.aws.pinpoint.model.ListRecommenderConfigurationsResponse(
        item.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def item
        : List[zio.aws.pinpoint.model.RecommenderConfigurationResponse.ReadOnly]
    def nextToken: Option[__string]
    def getItem: ZIO[Any, Nothing, List[
      zio.aws.pinpoint.model.RecommenderConfigurationResponse.ReadOnly
    ]] = ZIO.succeed(item)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.ListRecommenderConfigurationsResponse
  ) extends zio.aws.pinpoint.model.ListRecommenderConfigurationsResponse.ReadOnly {
    override val item: List[
      zio.aws.pinpoint.model.RecommenderConfigurationResponse.ReadOnly
    ] = impl
      .item()
      .asScala
      .map { item =>
        zio.aws.pinpoint.model.RecommenderConfigurationResponse.wrap(item)
      }
      .toList
    override val nextToken: Option[__string] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.ListRecommenderConfigurationsResponse
  ): zio.aws.pinpoint.model.ListRecommenderConfigurationsResponse.ReadOnly =
    new Wrapper(impl)
}
