package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class ListTemplateVersionsRequest(
    nextToken: Option[__string] = None,
    pageSize: Option[__string] = None,
    templateName: __string,
    templateType: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.ListTemplateVersionsRequest = {
    import ListTemplateVersionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.ListTemplateVersionsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => __string.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        pageSize.map(value => __string.unwrap(value): java.lang.String)
      )(_.pageSize)
      .templateName(__string.unwrap(templateName): java.lang.String)
      .templateType(__string.unwrap(templateType): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.ListTemplateVersionsRequest.ReadOnly =
    zio.aws.pinpoint.model.ListTemplateVersionsRequest.wrap(buildAwsValue())
}
object ListTemplateVersionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.ListTemplateVersionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.ListTemplateVersionsRequest =
      zio.aws.pinpoint.model.ListTemplateVersionsRequest(
        nextToken.map(value => value),
        pageSize.map(value => value),
        templateName,
        templateType
      )
    def nextToken: Option[__string]
    def pageSize: Option[__string]
    def templateName: __string
    def templateType: __string
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getPageSize: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("pageSize", pageSize)
    def getTemplateName: ZIO[Any, Nothing, __string] = ZIO.succeed(templateName)
    def getTemplateType: ZIO[Any, Nothing, __string] = ZIO.succeed(templateType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.ListTemplateVersionsRequest
  ) extends zio.aws.pinpoint.model.ListTemplateVersionsRequest.ReadOnly {
    override val nextToken: Option[__string] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val pageSize: Option[__string] = scala
      .Option(impl.pageSize())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val templateName: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.templateName())
    override val templateType: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.templateType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.ListTemplateVersionsRequest
  ): zio.aws.pinpoint.model.ListTemplateVersionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
