package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class ListTemplatesRequest(
    nextToken: Option[__string] = None,
    pageSize: Option[__string] = None,
    prefix: Option[__string] = None,
    templateType: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.ListTemplatesRequest = {
    import ListTemplatesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.ListTemplatesRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => __string.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        pageSize.map(value => __string.unwrap(value): java.lang.String)
      )(_.pageSize)
      .optionallyWith(
        prefix.map(value => __string.unwrap(value): java.lang.String)
      )(_.prefix)
      .optionallyWith(
        templateType.map(value => __string.unwrap(value): java.lang.String)
      )(_.templateType)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.ListTemplatesRequest.ReadOnly =
    zio.aws.pinpoint.model.ListTemplatesRequest.wrap(buildAwsValue())
}
object ListTemplatesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.ListTemplatesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.ListTemplatesRequest =
      zio.aws.pinpoint.model.ListTemplatesRequest(
        nextToken.map(value => value),
        pageSize.map(value => value),
        prefix.map(value => value),
        templateType.map(value => value)
      )
    def nextToken: Option[__string]
    def pageSize: Option[__string]
    def prefix: Option[__string]
    def templateType: Option[__string]
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getPageSize: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("pageSize", pageSize)
    def getPrefix: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("prefix", prefix)
    def getTemplateType: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("templateType", templateType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.ListTemplatesRequest
  ) extends zio.aws.pinpoint.model.ListTemplatesRequest.ReadOnly {
    override val nextToken: Option[__string] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val pageSize: Option[__string] = scala
      .Option(impl.pageSize())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val prefix: Option[__string] = scala
      .Option(impl.prefix())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val templateType: Option[__string] = scala
      .Option(impl.templateType())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.ListTemplatesRequest
  ): zio.aws.pinpoint.model.ListTemplatesRequest.ReadOnly = new Wrapper(impl)
}
