package zio.aws.pinpoint.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.{__integer, __boolean, __string}
import scala.jdk.CollectionConverters.*
final case class Message(
    action: Option[zio.aws.pinpoint.model.Action] = None,
    body: Option[__string] = None,
    imageIconUrl: Option[__string] = None,
    imageSmallIconUrl: Option[__string] = None,
    imageUrl: Option[__string] = None,
    jsonBody: Option[__string] = None,
    mediaUrl: Option[__string] = None,
    rawContent: Option[__string] = None,
    silentPush: Option[__boolean] = None,
    timeToLive: Option[__integer] = None,
    title: Option[__string] = None,
    url: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.Message = {
    import Message.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.Message
      .builder()
      .optionallyWith(action.map(value => value.unwrap))(_.action)
      .optionallyWith(
        body.map(value => __string.unwrap(value): java.lang.String)
      )(_.body)
      .optionallyWith(
        imageIconUrl.map(value => __string.unwrap(value): java.lang.String)
      )(_.imageIconUrl)
      .optionallyWith(
        imageSmallIconUrl.map(value => __string.unwrap(value): java.lang.String)
      )(_.imageSmallIconUrl)
      .optionallyWith(
        imageUrl.map(value => __string.unwrap(value): java.lang.String)
      )(_.imageUrl)
      .optionallyWith(
        jsonBody.map(value => __string.unwrap(value): java.lang.String)
      )(_.jsonBody)
      .optionallyWith(
        mediaUrl.map(value => __string.unwrap(value): java.lang.String)
      )(_.mediaUrl)
      .optionallyWith(
        rawContent.map(value => __string.unwrap(value): java.lang.String)
      )(_.rawContent)
      .optionallyWith(
        silentPush.map(value => __boolean.unwrap(value): java.lang.Boolean)
      )(_.silentPush)
      .optionallyWith(
        timeToLive.map(value => __integer.unwrap(value): Integer)
      )(_.timeToLive)
      .optionallyWith(
        title.map(value => __string.unwrap(value): java.lang.String)
      )(_.title)
      .optionallyWith(
        url.map(value => __string.unwrap(value): java.lang.String)
      )(_.url)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.Message.ReadOnly =
    zio.aws.pinpoint.model.Message.wrap(buildAwsValue())
}
object Message {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.pinpoint.model.Message] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.Message =
      zio.aws.pinpoint.model.Message(
        action.map(value => value),
        body.map(value => value),
        imageIconUrl.map(value => value),
        imageSmallIconUrl.map(value => value),
        imageUrl.map(value => value),
        jsonBody.map(value => value),
        mediaUrl.map(value => value),
        rawContent.map(value => value),
        silentPush.map(value => value),
        timeToLive.map(value => value),
        title.map(value => value),
        url.map(value => value)
      )
    def action: Option[zio.aws.pinpoint.model.Action]
    def body: Option[__string]
    def imageIconUrl: Option[__string]
    def imageSmallIconUrl: Option[__string]
    def imageUrl: Option[__string]
    def jsonBody: Option[__string]
    def mediaUrl: Option[__string]
    def rawContent: Option[__string]
    def silentPush: Option[__boolean]
    def timeToLive: Option[__integer]
    def title: Option[__string]
    def url: Option[__string]
    def getAction: ZIO[Any, AwsError, zio.aws.pinpoint.model.Action] =
      AwsError.unwrapOptionField("action", action)
    def getBody: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("body", body)
    def getImageIconUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("imageIconUrl", imageIconUrl)
    def getImageSmallIconUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("imageSmallIconUrl", imageSmallIconUrl)
    def getImageUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("imageUrl", imageUrl)
    def getJsonBody: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("jsonBody", jsonBody)
    def getMediaUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("mediaUrl", mediaUrl)
    def getRawContent: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("rawContent", rawContent)
    def getSilentPush: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("silentPush", silentPush)
    def getTimeToLive: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("timeToLive", timeToLive)
    def getTitle: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("title", title)
    def getUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("url", url)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.Message
  ) extends zio.aws.pinpoint.model.Message.ReadOnly {
    override val action: Option[zio.aws.pinpoint.model.Action] = scala
      .Option(impl.action())
      .map(value => zio.aws.pinpoint.model.Action.wrap(value))
    override val body: Option[__string] = scala
      .Option(impl.body())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val imageIconUrl: Option[__string] = scala
      .Option(impl.imageIconUrl())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val imageSmallIconUrl: Option[__string] = scala
      .Option(impl.imageSmallIconUrl())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val imageUrl: Option[__string] = scala
      .Option(impl.imageUrl())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val jsonBody: Option[__string] = scala
      .Option(impl.jsonBody())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val mediaUrl: Option[__string] = scala
      .Option(impl.mediaUrl())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val rawContent: Option[__string] = scala
      .Option(impl.rawContent())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val silentPush: Option[__boolean] = scala
      .Option(impl.silentPush())
      .map(value => zio.aws.pinpoint.model.primitives.__boolean(value))
    override val timeToLive: Option[__integer] = scala
      .Option(impl.timeToLive())
      .map(value => zio.aws.pinpoint.model.primitives.__integer(value))
    override val title: Option[__string] = scala
      .Option(impl.title())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val url: Option[__string] = scala
      .Option(impl.url())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.Message
  ): zio.aws.pinpoint.model.Message.ReadOnly = new Wrapper(impl)
}
