package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class MessageBody(
    message: Option[__string] = None,
    requestID: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.MessageBody = {
    import MessageBody.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.MessageBody
      .builder()
      .optionallyWith(
        message.map(value => __string.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(
        requestID.map(value => __string.unwrap(value): java.lang.String)
      )(_.requestID)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.MessageBody.ReadOnly =
    zio.aws.pinpoint.model.MessageBody.wrap(buildAwsValue())
}
object MessageBody {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.MessageBody
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.MessageBody = zio.aws.pinpoint.model
      .MessageBody(message.map(value => value), requestID.map(value => value))
    def message: Option[__string]
    def requestID: Option[__string]
    def getMessage: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("message", message)
    def getRequestID: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("requestID", requestID)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.MessageBody
  ) extends zio.aws.pinpoint.model.MessageBody.ReadOnly {
    override val message: Option[__string] = scala
      .Option(impl.message())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val requestID: Option[__string] = scala
      .Option(impl.requestID())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.MessageBody
  ): zio.aws.pinpoint.model.MessageBody.ReadOnly = new Wrapper(impl)
}
