package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class MessageConfiguration(
    admMessage: Option[zio.aws.pinpoint.model.Message] = None,
    apnsMessage: Option[zio.aws.pinpoint.model.Message] = None,
    baiduMessage: Option[zio.aws.pinpoint.model.Message] = None,
    customMessage: Option[zio.aws.pinpoint.model.CampaignCustomMessage] = None,
    defaultMessage: Option[zio.aws.pinpoint.model.Message] = None,
    emailMessage: Option[zio.aws.pinpoint.model.CampaignEmailMessage] = None,
    gcmMessage: Option[zio.aws.pinpoint.model.Message] = None,
    smsMessage: Option[zio.aws.pinpoint.model.CampaignSmsMessage] = None,
    inAppMessage: Option[zio.aws.pinpoint.model.CampaignInAppMessage] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.MessageConfiguration = {
    import MessageConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.MessageConfiguration
      .builder()
      .optionallyWith(admMessage.map(value => value.buildAwsValue()))(
        _.admMessage
      )
      .optionallyWith(apnsMessage.map(value => value.buildAwsValue()))(
        _.apnsMessage
      )
      .optionallyWith(baiduMessage.map(value => value.buildAwsValue()))(
        _.baiduMessage
      )
      .optionallyWith(customMessage.map(value => value.buildAwsValue()))(
        _.customMessage
      )
      .optionallyWith(defaultMessage.map(value => value.buildAwsValue()))(
        _.defaultMessage
      )
      .optionallyWith(emailMessage.map(value => value.buildAwsValue()))(
        _.emailMessage
      )
      .optionallyWith(gcmMessage.map(value => value.buildAwsValue()))(
        _.gcmMessage
      )
      .optionallyWith(smsMessage.map(value => value.buildAwsValue()))(
        _.smsMessage
      )
      .optionallyWith(inAppMessage.map(value => value.buildAwsValue()))(
        _.inAppMessage
      )
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.MessageConfiguration.ReadOnly =
    zio.aws.pinpoint.model.MessageConfiguration.wrap(buildAwsValue())
}
object MessageConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.MessageConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.MessageConfiguration =
      zio.aws.pinpoint.model.MessageConfiguration(
        admMessage.map(value => value.asEditable),
        apnsMessage.map(value => value.asEditable),
        baiduMessage.map(value => value.asEditable),
        customMessage.map(value => value.asEditable),
        defaultMessage.map(value => value.asEditable),
        emailMessage.map(value => value.asEditable),
        gcmMessage.map(value => value.asEditable),
        smsMessage.map(value => value.asEditable),
        inAppMessage.map(value => value.asEditable)
      )
    def admMessage: Option[zio.aws.pinpoint.model.Message.ReadOnly]
    def apnsMessage: Option[zio.aws.pinpoint.model.Message.ReadOnly]
    def baiduMessage: Option[zio.aws.pinpoint.model.Message.ReadOnly]
    def customMessage
        : Option[zio.aws.pinpoint.model.CampaignCustomMessage.ReadOnly]
    def defaultMessage: Option[zio.aws.pinpoint.model.Message.ReadOnly]
    def emailMessage
        : Option[zio.aws.pinpoint.model.CampaignEmailMessage.ReadOnly]
    def gcmMessage: Option[zio.aws.pinpoint.model.Message.ReadOnly]
    def smsMessage: Option[zio.aws.pinpoint.model.CampaignSmsMessage.ReadOnly]
    def inAppMessage
        : Option[zio.aws.pinpoint.model.CampaignInAppMessage.ReadOnly]
    def getAdmMessage
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.Message.ReadOnly] =
      AwsError.unwrapOptionField("admMessage", admMessage)
    def getApnsMessage
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.Message.ReadOnly] =
      AwsError.unwrapOptionField("apnsMessage", apnsMessage)
    def getBaiduMessage
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.Message.ReadOnly] =
      AwsError.unwrapOptionField("baiduMessage", baiduMessage)
    def getCustomMessage: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.CampaignCustomMessage.ReadOnly
    ] = AwsError.unwrapOptionField("customMessage", customMessage)
    def getDefaultMessage
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.Message.ReadOnly] =
      AwsError.unwrapOptionField("defaultMessage", defaultMessage)
    def getEmailMessage: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.CampaignEmailMessage.ReadOnly
    ] = AwsError.unwrapOptionField("emailMessage", emailMessage)
    def getGcmMessage
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.Message.ReadOnly] =
      AwsError.unwrapOptionField("gcmMessage", gcmMessage)
    def getSmsMessage: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.CampaignSmsMessage.ReadOnly
    ] = AwsError.unwrapOptionField("smsMessage", smsMessage)
    def getInAppMessage: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.CampaignInAppMessage.ReadOnly
    ] = AwsError.unwrapOptionField("inAppMessage", inAppMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.MessageConfiguration
  ) extends zio.aws.pinpoint.model.MessageConfiguration.ReadOnly {
    override val admMessage: Option[zio.aws.pinpoint.model.Message.ReadOnly] =
      scala
        .Option(impl.admMessage())
        .map(value => zio.aws.pinpoint.model.Message.wrap(value))
    override val apnsMessage: Option[zio.aws.pinpoint.model.Message.ReadOnly] =
      scala
        .Option(impl.apnsMessage())
        .map(value => zio.aws.pinpoint.model.Message.wrap(value))
    override val baiduMessage: Option[zio.aws.pinpoint.model.Message.ReadOnly] =
      scala
        .Option(impl.baiduMessage())
        .map(value => zio.aws.pinpoint.model.Message.wrap(value))
    override val customMessage
        : Option[zio.aws.pinpoint.model.CampaignCustomMessage.ReadOnly] = scala
      .Option(impl.customMessage())
      .map(value => zio.aws.pinpoint.model.CampaignCustomMessage.wrap(value))
    override val defaultMessage
        : Option[zio.aws.pinpoint.model.Message.ReadOnly] = scala
      .Option(impl.defaultMessage())
      .map(value => zio.aws.pinpoint.model.Message.wrap(value))
    override val emailMessage
        : Option[zio.aws.pinpoint.model.CampaignEmailMessage.ReadOnly] = scala
      .Option(impl.emailMessage())
      .map(value => zio.aws.pinpoint.model.CampaignEmailMessage.wrap(value))
    override val gcmMessage: Option[zio.aws.pinpoint.model.Message.ReadOnly] =
      scala
        .Option(impl.gcmMessage())
        .map(value => zio.aws.pinpoint.model.Message.wrap(value))
    override val smsMessage
        : Option[zio.aws.pinpoint.model.CampaignSmsMessage.ReadOnly] = scala
      .Option(impl.smsMessage())
      .map(value => zio.aws.pinpoint.model.CampaignSmsMessage.wrap(value))
    override val inAppMessage
        : Option[zio.aws.pinpoint.model.CampaignInAppMessage.ReadOnly] = scala
      .Option(impl.inAppMessage())
      .map(value => zio.aws.pinpoint.model.CampaignInAppMessage.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.MessageConfiguration
  ): zio.aws.pinpoint.model.MessageConfiguration.ReadOnly = new Wrapper(impl)
}
