package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class MessageRequest(
    addresses: Option[
      Map[__string, zio.aws.pinpoint.model.AddressConfiguration]
    ] = None,
    context: Option[Map[__string, __string]] = None,
    endpoints: Option[
      Map[__string, zio.aws.pinpoint.model.EndpointSendConfiguration]
    ] = None,
    messageConfiguration: zio.aws.pinpoint.model.DirectMessageConfiguration,
    templateConfiguration: Option[
      zio.aws.pinpoint.model.TemplateConfiguration
    ] = None,
    traceId: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.MessageRequest = {
    import MessageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.MessageRequest
      .builder()
      .optionallyWith(
        addresses.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.addresses)
      .optionallyWith(
        context.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> (__string.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.context)
      .optionallyWith(
        endpoints.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.endpoints)
      .messageConfiguration(messageConfiguration.buildAwsValue())
      .optionallyWith(
        templateConfiguration.map(value => value.buildAwsValue())
      )(_.templateConfiguration)
      .optionallyWith(
        traceId.map(value => __string.unwrap(value): java.lang.String)
      )(_.traceId)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.MessageRequest.ReadOnly =
    zio.aws.pinpoint.model.MessageRequest.wrap(buildAwsValue())
}
object MessageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.MessageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.MessageRequest =
      zio.aws.pinpoint.model.MessageRequest(
        addresses.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        context.map(value => value),
        endpoints.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        messageConfiguration.asEditable,
        templateConfiguration.map(value => value.asEditable),
        traceId.map(value => value)
      )
    def addresses: Option[
      Map[__string, zio.aws.pinpoint.model.AddressConfiguration.ReadOnly]
    ]
    def context: Option[Map[__string, __string]]
    def endpoints: Option[
      Map[__string, zio.aws.pinpoint.model.EndpointSendConfiguration.ReadOnly]
    ]
    def messageConfiguration
        : zio.aws.pinpoint.model.DirectMessageConfiguration.ReadOnly
    def templateConfiguration
        : Option[zio.aws.pinpoint.model.TemplateConfiguration.ReadOnly]
    def traceId: Option[__string]
    def getAddresses: ZIO[Any, AwsError, Map[
      __string,
      zio.aws.pinpoint.model.AddressConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField("addresses", addresses)
    def getContext: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("context", context)
    def getEndpoints: ZIO[Any, AwsError, Map[
      __string,
      zio.aws.pinpoint.model.EndpointSendConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField("endpoints", endpoints)
    def getMessageConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.pinpoint.model.DirectMessageConfiguration.ReadOnly
    ] = ZIO.succeed(messageConfiguration)
    def getTemplateConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.TemplateConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("templateConfiguration", templateConfiguration)
    def getTraceId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("traceId", traceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.MessageRequest
  ) extends zio.aws.pinpoint.model.MessageRequest.ReadOnly {
    override val addresses: Option[
      Map[__string, zio.aws.pinpoint.model.AddressConfiguration.ReadOnly]
    ] = scala
      .Option(impl.addresses())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.pinpoint.model.primitives.__string(
              key
            ) -> zio.aws.pinpoint.model.AddressConfiguration.wrap(value)
          })
          .toMap
      )
    override val context: Option[Map[__string, __string]] = scala
      .Option(impl.context())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.pinpoint.model.primitives.__string(
              key
            ) -> zio.aws.pinpoint.model.primitives.__string(value)
          })
          .toMap
      )
    override val endpoints: Option[
      Map[__string, zio.aws.pinpoint.model.EndpointSendConfiguration.ReadOnly]
    ] = scala
      .Option(impl.endpoints())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.pinpoint.model.primitives.__string(
              key
            ) -> zio.aws.pinpoint.model.EndpointSendConfiguration.wrap(value)
          })
          .toMap
      )
    override val messageConfiguration
        : zio.aws.pinpoint.model.DirectMessageConfiguration.ReadOnly =
      zio.aws.pinpoint.model.DirectMessageConfiguration
        .wrap(impl.messageConfiguration())
    override val templateConfiguration
        : Option[zio.aws.pinpoint.model.TemplateConfiguration.ReadOnly] = scala
      .Option(impl.templateConfiguration())
      .map(value => zio.aws.pinpoint.model.TemplateConfiguration.wrap(value))
    override val traceId: Option[__string] = scala
      .Option(impl.traceId())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.MessageRequest
  ): zio.aws.pinpoint.model.MessageRequest.ReadOnly = new Wrapper(impl)
}
