package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class MessageResponse(
    applicationId: __string,
    endpointResult: Option[
      Map[__string, zio.aws.pinpoint.model.EndpointMessageResult]
    ] = None,
    requestId: Option[__string] = None,
    result: Option[Map[__string, zio.aws.pinpoint.model.MessageResult]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.MessageResponse = {
    import MessageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.MessageResponse
      .builder()
      .applicationId(__string.unwrap(applicationId): java.lang.String)
      .optionallyWith(
        endpointResult.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.endpointResult)
      .optionallyWith(
        requestId.map(value => __string.unwrap(value): java.lang.String)
      )(_.requestId)
      .optionallyWith(
        result.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.result)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.MessageResponse.ReadOnly =
    zio.aws.pinpoint.model.MessageResponse.wrap(buildAwsValue())
}
object MessageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.MessageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.MessageResponse =
      zio.aws.pinpoint.model.MessageResponse(
        applicationId,
        endpointResult.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        requestId.map(value => value),
        result.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def applicationId: __string
    def endpointResult: Option[
      Map[__string, zio.aws.pinpoint.model.EndpointMessageResult.ReadOnly]
    ]
    def requestId: Option[__string]
    def result
        : Option[Map[__string, zio.aws.pinpoint.model.MessageResult.ReadOnly]]
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
    def getEndpointResult: ZIO[Any, AwsError, Map[
      __string,
      zio.aws.pinpoint.model.EndpointMessageResult.ReadOnly
    ]] = AwsError.unwrapOptionField("endpointResult", endpointResult)
    def getRequestId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getResult: ZIO[Any, AwsError, Map[
      __string,
      zio.aws.pinpoint.model.MessageResult.ReadOnly
    ]] = AwsError.unwrapOptionField("result", result)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.MessageResponse
  ) extends zio.aws.pinpoint.model.MessageResponse.ReadOnly {
    override val applicationId: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.applicationId())
    override val endpointResult: Option[
      Map[__string, zio.aws.pinpoint.model.EndpointMessageResult.ReadOnly]
    ] = scala
      .Option(impl.endpointResult())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.pinpoint.model.primitives.__string(
              key
            ) -> zio.aws.pinpoint.model.EndpointMessageResult.wrap(value)
          })
          .toMap
      )
    override val requestId: Option[__string] = scala
      .Option(impl.requestId())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val result
        : Option[Map[__string, zio.aws.pinpoint.model.MessageResult.ReadOnly]] =
      scala
        .Option(impl.result())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.pinpoint.model.primitives.__string(
                key
              ) -> zio.aws.pinpoint.model.MessageResult.wrap(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.MessageResponse
  ): zio.aws.pinpoint.model.MessageResponse.ReadOnly = new Wrapper(impl)
}
