package zio.aws.pinpoint.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.{__integer, __string}
import scala.jdk.CollectionConverters.*
final case class MessageResult(
    deliveryStatus: zio.aws.pinpoint.model.DeliveryStatus,
    messageId: Option[__string] = None,
    statusCode: __integer,
    statusMessage: Option[__string] = None,
    updatedToken: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.MessageResult = {
    import MessageResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.MessageResult
      .builder()
      .deliveryStatus(deliveryStatus.unwrap)
      .optionallyWith(
        messageId.map(value => __string.unwrap(value): java.lang.String)
      )(_.messageId)
      .statusCode(__integer.unwrap(statusCode): Integer)
      .optionallyWith(
        statusMessage.map(value => __string.unwrap(value): java.lang.String)
      )(_.statusMessage)
      .optionallyWith(
        updatedToken.map(value => __string.unwrap(value): java.lang.String)
      )(_.updatedToken)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.MessageResult.ReadOnly =
    zio.aws.pinpoint.model.MessageResult.wrap(buildAwsValue())
}
object MessageResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.MessageResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.MessageResult =
      zio.aws.pinpoint.model.MessageResult(
        deliveryStatus,
        messageId.map(value => value),
        statusCode,
        statusMessage.map(value => value),
        updatedToken.map(value => value)
      )
    def deliveryStatus: zio.aws.pinpoint.model.DeliveryStatus
    def messageId: Option[__string]
    def statusCode: __integer
    def statusMessage: Option[__string]
    def updatedToken: Option[__string]
    def getDeliveryStatus
        : ZIO[Any, Nothing, zio.aws.pinpoint.model.DeliveryStatus] =
      ZIO.succeed(deliveryStatus)
    def getMessageId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("messageId", messageId)
    def getStatusCode: ZIO[Any, Nothing, __integer] = ZIO.succeed(statusCode)
    def getStatusMessage: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getUpdatedToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("updatedToken", updatedToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.MessageResult
  ) extends zio.aws.pinpoint.model.MessageResult.ReadOnly {
    override val deliveryStatus: zio.aws.pinpoint.model.DeliveryStatus =
      zio.aws.pinpoint.model.DeliveryStatus.wrap(impl.deliveryStatus())
    override val messageId: Option[__string] = scala
      .Option(impl.messageId())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val statusCode: __integer =
      zio.aws.pinpoint.model.primitives.__integer(impl.statusCode())
    override val statusMessage: Option[__string] = scala
      .Option(impl.statusMessage())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val updatedToken: Option[__string] = scala
      .Option(impl.updatedToken())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.MessageResult
  ): zio.aws.pinpoint.model.MessageResult.ReadOnly = new Wrapper(impl)
}
