package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class MultiConditionalBranch(
    condition: Option[zio.aws.pinpoint.model.SimpleCondition] = None,
    nextActivity: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.MultiConditionalBranch = {
    import MultiConditionalBranch.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.MultiConditionalBranch
      .builder()
      .optionallyWith(condition.map(value => value.buildAwsValue()))(
        _.condition
      )
      .optionallyWith(
        nextActivity.map(value => __string.unwrap(value): java.lang.String)
      )(_.nextActivity)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.MultiConditionalBranch.ReadOnly =
    zio.aws.pinpoint.model.MultiConditionalBranch.wrap(buildAwsValue())
}
object MultiConditionalBranch {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.MultiConditionalBranch
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.MultiConditionalBranch =
      zio.aws.pinpoint.model.MultiConditionalBranch(
        condition.map(value => value.asEditable),
        nextActivity.map(value => value)
      )
    def condition: Option[zio.aws.pinpoint.model.SimpleCondition.ReadOnly]
    def nextActivity: Option[__string]
    def getCondition
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.SimpleCondition.ReadOnly] =
      AwsError.unwrapOptionField("condition", condition)
    def getNextActivity: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextActivity", nextActivity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.MultiConditionalBranch
  ) extends zio.aws.pinpoint.model.MultiConditionalBranch.ReadOnly {
    override val condition
        : Option[zio.aws.pinpoint.model.SimpleCondition.ReadOnly] = scala
      .Option(impl.condition())
      .map(value => zio.aws.pinpoint.model.SimpleCondition.wrap(value))
    override val nextActivity: Option[__string] = scala
      .Option(impl.nextActivity())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.MultiConditionalBranch
  ): zio.aws.pinpoint.model.MultiConditionalBranch.ReadOnly = new Wrapper(impl)
}
