package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class MultiConditionalSplitActivity(
    branches: Option[Iterable[zio.aws.pinpoint.model.MultiConditionalBranch]] =
      None,
    defaultActivity: Option[__string] = None,
    evaluationWaitTime: Option[zio.aws.pinpoint.model.WaitTime] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.MultiConditionalSplitActivity = {
    import MultiConditionalSplitActivity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.MultiConditionalSplitActivity
      .builder()
      .optionallyWith(
        branches.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.branches)
      .optionallyWith(
        defaultActivity.map(value => __string.unwrap(value): java.lang.String)
      )(_.defaultActivity)
      .optionallyWith(evaluationWaitTime.map(value => value.buildAwsValue()))(
        _.evaluationWaitTime
      )
      .build()
  }
  def asReadOnly
      : zio.aws.pinpoint.model.MultiConditionalSplitActivity.ReadOnly =
    zio.aws.pinpoint.model.MultiConditionalSplitActivity.wrap(buildAwsValue())
}
object MultiConditionalSplitActivity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.MultiConditionalSplitActivity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.MultiConditionalSplitActivity =
      zio.aws.pinpoint.model.MultiConditionalSplitActivity(
        branches.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        defaultActivity.map(value => value),
        evaluationWaitTime.map(value => value.asEditable)
      )
    def branches
        : Option[List[zio.aws.pinpoint.model.MultiConditionalBranch.ReadOnly]]
    def defaultActivity: Option[__string]
    def evaluationWaitTime: Option[zio.aws.pinpoint.model.WaitTime.ReadOnly]
    def getBranches: ZIO[Any, AwsError, List[
      zio.aws.pinpoint.model.MultiConditionalBranch.ReadOnly
    ]] = AwsError.unwrapOptionField("branches", branches)
    def getDefaultActivity: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("defaultActivity", defaultActivity)
    def getEvaluationWaitTime
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.WaitTime.ReadOnly] =
      AwsError.unwrapOptionField("evaluationWaitTime", evaluationWaitTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.MultiConditionalSplitActivity
  ) extends zio.aws.pinpoint.model.MultiConditionalSplitActivity.ReadOnly {
    override val branches
        : Option[List[zio.aws.pinpoint.model.MultiConditionalBranch.ReadOnly]] =
      scala
        .Option(impl.branches())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.pinpoint.model.MultiConditionalBranch.wrap(item)
          }.toList
        )
    override val defaultActivity: Option[__string] = scala
      .Option(impl.defaultActivity())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val evaluationWaitTime
        : Option[zio.aws.pinpoint.model.WaitTime.ReadOnly] = scala
      .Option(impl.evaluationWaitTime())
      .map(value => zio.aws.pinpoint.model.WaitTime.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.MultiConditionalSplitActivity
  ): zio.aws.pinpoint.model.MultiConditionalSplitActivity.ReadOnly =
    new Wrapper(impl)
}
