package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class NumberValidateRequest(
    isoCountryCode: Option[__string] = None,
    phoneNumber: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.NumberValidateRequest = {
    import NumberValidateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.NumberValidateRequest
      .builder()
      .optionallyWith(
        isoCountryCode.map(value => __string.unwrap(value): java.lang.String)
      )(_.isoCountryCode)
      .optionallyWith(
        phoneNumber.map(value => __string.unwrap(value): java.lang.String)
      )(_.phoneNumber)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.NumberValidateRequest.ReadOnly =
    zio.aws.pinpoint.model.NumberValidateRequest.wrap(buildAwsValue())
}
object NumberValidateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.NumberValidateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.NumberValidateRequest =
      zio.aws.pinpoint.model.NumberValidateRequest(
        isoCountryCode.map(value => value),
        phoneNumber.map(value => value)
      )
    def isoCountryCode: Option[__string]
    def phoneNumber: Option[__string]
    def getIsoCountryCode: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("isoCountryCode", isoCountryCode)
    def getPhoneNumber: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("phoneNumber", phoneNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.NumberValidateRequest
  ) extends zio.aws.pinpoint.model.NumberValidateRequest.ReadOnly {
    override val isoCountryCode: Option[__string] = scala
      .Option(impl.isoCountryCode())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val phoneNumber: Option[__string] = scala
      .Option(impl.phoneNumber())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.NumberValidateRequest
  ): zio.aws.pinpoint.model.NumberValidateRequest.ReadOnly = new Wrapper(impl)
}
