package zio.aws.pinpoint.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.{__integer, __string}
import scala.jdk.CollectionConverters.*
final case class NumberValidateResponse(
    carrier: Option[__string] = None,
    city: Option[__string] = None,
    cleansedPhoneNumberE164: Option[__string] = None,
    cleansedPhoneNumberNational: Option[__string] = None,
    country: Option[__string] = None,
    countryCodeIso2: Option[__string] = None,
    countryCodeNumeric: Option[__string] = None,
    county: Option[__string] = None,
    originalCountryCodeIso2: Option[__string] = None,
    originalPhoneNumber: Option[__string] = None,
    phoneType: Option[__string] = None,
    phoneTypeCode: Option[__integer] = None,
    timezone: Option[__string] = None,
    zipCode: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.NumberValidateResponse = {
    import NumberValidateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.NumberValidateResponse
      .builder()
      .optionallyWith(
        carrier.map(value => __string.unwrap(value): java.lang.String)
      )(_.carrier)
      .optionallyWith(
        city.map(value => __string.unwrap(value): java.lang.String)
      )(_.city)
      .optionallyWith(
        cleansedPhoneNumberE164.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.cleansedPhoneNumberE164)
      .optionallyWith(
        cleansedPhoneNumberNational.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.cleansedPhoneNumberNational)
      .optionallyWith(
        country.map(value => __string.unwrap(value): java.lang.String)
      )(_.country)
      .optionallyWith(
        countryCodeIso2.map(value => __string.unwrap(value): java.lang.String)
      )(_.countryCodeIso2)
      .optionallyWith(
        countryCodeNumeric.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.countryCodeNumeric)
      .optionallyWith(
        county.map(value => __string.unwrap(value): java.lang.String)
      )(_.county)
      .optionallyWith(
        originalCountryCodeIso2.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.originalCountryCodeIso2)
      .optionallyWith(
        originalPhoneNumber.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.originalPhoneNumber)
      .optionallyWith(
        phoneType.map(value => __string.unwrap(value): java.lang.String)
      )(_.phoneType)
      .optionallyWith(
        phoneTypeCode.map(value => __integer.unwrap(value): Integer)
      )(_.phoneTypeCode)
      .optionallyWith(
        timezone.map(value => __string.unwrap(value): java.lang.String)
      )(_.timezone)
      .optionallyWith(
        zipCode.map(value => __string.unwrap(value): java.lang.String)
      )(_.zipCode)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.NumberValidateResponse.ReadOnly =
    zio.aws.pinpoint.model.NumberValidateResponse.wrap(buildAwsValue())
}
object NumberValidateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.NumberValidateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.NumberValidateResponse =
      zio.aws.pinpoint.model.NumberValidateResponse(
        carrier.map(value => value),
        city.map(value => value),
        cleansedPhoneNumberE164.map(value => value),
        cleansedPhoneNumberNational.map(value => value),
        country.map(value => value),
        countryCodeIso2.map(value => value),
        countryCodeNumeric.map(value => value),
        county.map(value => value),
        originalCountryCodeIso2.map(value => value),
        originalPhoneNumber.map(value => value),
        phoneType.map(value => value),
        phoneTypeCode.map(value => value),
        timezone.map(value => value),
        zipCode.map(value => value)
      )
    def carrier: Option[__string]
    def city: Option[__string]
    def cleansedPhoneNumberE164: Option[__string]
    def cleansedPhoneNumberNational: Option[__string]
    def country: Option[__string]
    def countryCodeIso2: Option[__string]
    def countryCodeNumeric: Option[__string]
    def county: Option[__string]
    def originalCountryCodeIso2: Option[__string]
    def originalPhoneNumber: Option[__string]
    def phoneType: Option[__string]
    def phoneTypeCode: Option[__integer]
    def timezone: Option[__string]
    def zipCode: Option[__string]
    def getCarrier: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("carrier", carrier)
    def getCity: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("city", city)
    def getCleansedPhoneNumberE164: ZIO[Any, AwsError, __string] = AwsError
      .unwrapOptionField("cleansedPhoneNumberE164", cleansedPhoneNumberE164)
    def getCleansedPhoneNumberNational: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField(
        "cleansedPhoneNumberNational",
        cleansedPhoneNumberNational
      )
    def getCountry: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("country", country)
    def getCountryCodeIso2: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("countryCodeIso2", countryCodeIso2)
    def getCountryCodeNumeric: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("countryCodeNumeric", countryCodeNumeric)
    def getCounty: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("county", county)
    def getOriginalCountryCodeIso2: ZIO[Any, AwsError, __string] = AwsError
      .unwrapOptionField("originalCountryCodeIso2", originalCountryCodeIso2)
    def getOriginalPhoneNumber: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("originalPhoneNumber", originalPhoneNumber)
    def getPhoneType: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("phoneType", phoneType)
    def getPhoneTypeCode: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("phoneTypeCode", phoneTypeCode)
    def getTimezone: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("timezone", timezone)
    def getZipCode: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("zipCode", zipCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.NumberValidateResponse
  ) extends zio.aws.pinpoint.model.NumberValidateResponse.ReadOnly {
    override val carrier: Option[__string] = scala
      .Option(impl.carrier())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val city: Option[__string] = scala
      .Option(impl.city())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val cleansedPhoneNumberE164: Option[__string] = scala
      .Option(impl.cleansedPhoneNumberE164())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val cleansedPhoneNumberNational: Option[__string] = scala
      .Option(impl.cleansedPhoneNumberNational())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val country: Option[__string] = scala
      .Option(impl.country())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val countryCodeIso2: Option[__string] = scala
      .Option(impl.countryCodeIso2())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val countryCodeNumeric: Option[__string] = scala
      .Option(impl.countryCodeNumeric())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val county: Option[__string] = scala
      .Option(impl.county())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val originalCountryCodeIso2: Option[__string] = scala
      .Option(impl.originalCountryCodeIso2())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val originalPhoneNumber: Option[__string] = scala
      .Option(impl.originalPhoneNumber())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val phoneType: Option[__string] = scala
      .Option(impl.phoneType())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val phoneTypeCode: Option[__integer] = scala
      .Option(impl.phoneTypeCode())
      .map(value => zio.aws.pinpoint.model.primitives.__integer(value))
    override val timezone: Option[__string] = scala
      .Option(impl.timezone())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val zipCode: Option[__string] = scala
      .Option(impl.zipCode())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.NumberValidateResponse
  ): zio.aws.pinpoint.model.NumberValidateResponse.ReadOnly = new Wrapper(impl)
}
