package zio.aws.pinpoint.model
import scala.jdk.CollectionConverters.*
sealed trait Operator {
  def unwrap: software.amazon.awssdk.services.pinpoint.model.Operator
}
object Operator {
  def wrap(
      value: software.amazon.awssdk.services.pinpoint.model.Operator
  ): zio.aws.pinpoint.model.Operator = value match {
    case software.amazon.awssdk.services.pinpoint.model.Operator.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.pinpoint.model.Operator.ALL =>
      val r = ALL
      r
    case software.amazon.awssdk.services.pinpoint.model.Operator.ANY =>
      val r = ANY
      r
  }
  case object unknownToSdkVersion extends zio.aws.pinpoint.model.Operator {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.Operator =
      software.amazon.awssdk.services.pinpoint.model.Operator.UNKNOWN_TO_SDK_VERSION
  }
  case object ALL extends zio.aws.pinpoint.model.Operator {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.Operator =
      software.amazon.awssdk.services.pinpoint.model.Operator.ALL
  }
  case object ANY extends zio.aws.pinpoint.model.Operator {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.Operator =
      software.amazon.awssdk.services.pinpoint.model.Operator.ANY
  }
}
