package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class PushMessageActivity(
    messageConfig: Option[zio.aws.pinpoint.model.JourneyPushMessage] = None,
    nextActivity: Option[__string] = None,
    templateName: Option[__string] = None,
    templateVersion: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.PushMessageActivity = {
    import PushMessageActivity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.PushMessageActivity
      .builder()
      .optionallyWith(messageConfig.map(value => value.buildAwsValue()))(
        _.messageConfig
      )
      .optionallyWith(
        nextActivity.map(value => __string.unwrap(value): java.lang.String)
      )(_.nextActivity)
      .optionallyWith(
        templateName.map(value => __string.unwrap(value): java.lang.String)
      )(_.templateName)
      .optionallyWith(
        templateVersion.map(value => __string.unwrap(value): java.lang.String)
      )(_.templateVersion)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.PushMessageActivity.ReadOnly =
    zio.aws.pinpoint.model.PushMessageActivity.wrap(buildAwsValue())
}
object PushMessageActivity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.PushMessageActivity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.PushMessageActivity =
      zio.aws.pinpoint.model.PushMessageActivity(
        messageConfig.map(value => value.asEditable),
        nextActivity.map(value => value),
        templateName.map(value => value),
        templateVersion.map(value => value)
      )
    def messageConfig
        : Option[zio.aws.pinpoint.model.JourneyPushMessage.ReadOnly]
    def nextActivity: Option[__string]
    def templateName: Option[__string]
    def templateVersion: Option[__string]
    def getMessageConfig: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.JourneyPushMessage.ReadOnly
    ] = AwsError.unwrapOptionField("messageConfig", messageConfig)
    def getNextActivity: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextActivity", nextActivity)
    def getTemplateName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("templateName", templateName)
    def getTemplateVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("templateVersion", templateVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.PushMessageActivity
  ) extends zio.aws.pinpoint.model.PushMessageActivity.ReadOnly {
    override val messageConfig
        : Option[zio.aws.pinpoint.model.JourneyPushMessage.ReadOnly] = scala
      .Option(impl.messageConfig())
      .map(value => zio.aws.pinpoint.model.JourneyPushMessage.wrap(value))
    override val nextActivity: Option[__string] = scala
      .Option(impl.nextActivity())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val templateName: Option[__string] = scala
      .Option(impl.templateName())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val templateVersion: Option[__string] = scala
      .Option(impl.templateVersion())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.PushMessageActivity
  ): zio.aws.pinpoint.model.PushMessageActivity.ReadOnly = new Wrapper(impl)
}
