package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class PushNotificationTemplateRequest(
    adm: Option[zio.aws.pinpoint.model.AndroidPushNotificationTemplate] = None,
    apns: Option[zio.aws.pinpoint.model.APNSPushNotificationTemplate] = None,
    baidu: Option[zio.aws.pinpoint.model.AndroidPushNotificationTemplate] =
      None,
    defaultValue: Option[
      zio.aws.pinpoint.model.DefaultPushNotificationTemplate
    ] = None,
    defaultSubstitutions: Option[__string] = None,
    gcm: Option[zio.aws.pinpoint.model.AndroidPushNotificationTemplate] = None,
    recommenderId: Option[__string] = None,
    tags: Option[Map[__string, __string]] = None,
    templateDescription: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.PushNotificationTemplateRequest = {
    import PushNotificationTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.PushNotificationTemplateRequest
      .builder()
      .optionallyWith(adm.map(value => value.buildAwsValue()))(_.adm)
      .optionallyWith(apns.map(value => value.buildAwsValue()))(_.apns)
      .optionallyWith(baidu.map(value => value.buildAwsValue()))(_.baidu)
      .optionallyWith(defaultValue.map(value => value.buildAwsValue()))(
        _.defaultValue
      )
      .optionallyWith(
        defaultSubstitutions.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.defaultSubstitutions)
      .optionallyWith(gcm.map(value => value.buildAwsValue()))(_.gcm)
      .optionallyWith(
        recommenderId.map(value => __string.unwrap(value): java.lang.String)
      )(_.recommenderId)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> (__string
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        templateDescription.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.templateDescription)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpoint.model.PushNotificationTemplateRequest.ReadOnly =
    zio.aws.pinpoint.model.PushNotificationTemplateRequest.wrap(buildAwsValue())
}
object PushNotificationTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.PushNotificationTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.PushNotificationTemplateRequest =
      zio.aws.pinpoint.model.PushNotificationTemplateRequest(
        adm.map(value => value.asEditable),
        apns.map(value => value.asEditable),
        baidu.map(value => value.asEditable),
        defaultValue.map(value => value.asEditable),
        defaultSubstitutions.map(value => value),
        gcm.map(value => value.asEditable),
        recommenderId.map(value => value),
        tags.map(value => value),
        templateDescription.map(value => value)
      )
    def adm: Option[
      zio.aws.pinpoint.model.AndroidPushNotificationTemplate.ReadOnly
    ]
    def apns
        : Option[zio.aws.pinpoint.model.APNSPushNotificationTemplate.ReadOnly]
    def baidu: Option[
      zio.aws.pinpoint.model.AndroidPushNotificationTemplate.ReadOnly
    ]
    def defaultValue: Option[
      zio.aws.pinpoint.model.DefaultPushNotificationTemplate.ReadOnly
    ]
    def defaultSubstitutions: Option[__string]
    def gcm: Option[
      zio.aws.pinpoint.model.AndroidPushNotificationTemplate.ReadOnly
    ]
    def recommenderId: Option[__string]
    def tags: Option[Map[__string, __string]]
    def templateDescription: Option[__string]
    def getAdm: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.AndroidPushNotificationTemplate.ReadOnly
    ] = AwsError.unwrapOptionField("adm", adm)
    def getApns: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.APNSPushNotificationTemplate.ReadOnly
    ] = AwsError.unwrapOptionField("apns", apns)
    def getBaidu: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.AndroidPushNotificationTemplate.ReadOnly
    ] = AwsError.unwrapOptionField("baidu", baidu)
    def getDefaultValue: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.DefaultPushNotificationTemplate.ReadOnly
    ] = AwsError.unwrapOptionField("defaultValue", defaultValue)
    def getDefaultSubstitutions: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("defaultSubstitutions", defaultSubstitutions)
    def getGcm: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.AndroidPushNotificationTemplate.ReadOnly
    ] = AwsError.unwrapOptionField("gcm", gcm)
    def getRecommenderId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("recommenderId", recommenderId)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTemplateDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("templateDescription", templateDescription)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.PushNotificationTemplateRequest
  ) extends zio.aws.pinpoint.model.PushNotificationTemplateRequest.ReadOnly {
    override val adm: Option[
      zio.aws.pinpoint.model.AndroidPushNotificationTemplate.ReadOnly
    ] = scala
      .Option(impl.adm())
      .map(value =>
        zio.aws.pinpoint.model.AndroidPushNotificationTemplate.wrap(value)
      )
    override val apns
        : Option[zio.aws.pinpoint.model.APNSPushNotificationTemplate.ReadOnly] =
      scala
        .Option(impl.apns())
        .map(value =>
          zio.aws.pinpoint.model.APNSPushNotificationTemplate.wrap(value)
        )
    override val baidu: Option[
      zio.aws.pinpoint.model.AndroidPushNotificationTemplate.ReadOnly
    ] = scala
      .Option(impl.baidu())
      .map(value =>
        zio.aws.pinpoint.model.AndroidPushNotificationTemplate.wrap(value)
      )
    override val defaultValue: Option[
      zio.aws.pinpoint.model.DefaultPushNotificationTemplate.ReadOnly
    ] = scala
      .Option(impl.defaultValue())
      .map(value =>
        zio.aws.pinpoint.model.DefaultPushNotificationTemplate.wrap(value)
      )
    override val defaultSubstitutions: Option[__string] = scala
      .Option(impl.defaultSubstitutions())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val gcm: Option[
      zio.aws.pinpoint.model.AndroidPushNotificationTemplate.ReadOnly
    ] = scala
      .Option(impl.gcm())
      .map(value =>
        zio.aws.pinpoint.model.AndroidPushNotificationTemplate.wrap(value)
      )
    override val recommenderId: Option[__string] = scala
      .Option(impl.recommenderId())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val tags: Option[Map[__string, __string]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.pinpoint.model.primitives.__string(
              key
            ) -> zio.aws.pinpoint.model.primitives.__string(value)
          })
          .toMap
      )
    override val templateDescription: Option[__string] = scala
      .Option(impl.templateDescription())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.PushNotificationTemplateRequest
  ): zio.aws.pinpoint.model.PushNotificationTemplateRequest.ReadOnly =
    new Wrapper(impl)
}
