package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class PushNotificationTemplateResponse(
    adm: Option[zio.aws.pinpoint.model.AndroidPushNotificationTemplate] = None,
    apns: Option[zio.aws.pinpoint.model.APNSPushNotificationTemplate] = None,
    arn: Option[__string] = None,
    baidu: Option[zio.aws.pinpoint.model.AndroidPushNotificationTemplate] =
      None,
    creationDate: __string,
    defaultValue: Option[
      zio.aws.pinpoint.model.DefaultPushNotificationTemplate
    ] = None,
    defaultSubstitutions: Option[__string] = None,
    gcm: Option[zio.aws.pinpoint.model.AndroidPushNotificationTemplate] = None,
    lastModifiedDate: __string,
    recommenderId: Option[__string] = None,
    tags: Option[Map[__string, __string]] = None,
    templateDescription: Option[__string] = None,
    templateName: __string,
    templateType: zio.aws.pinpoint.model.TemplateType,
    version: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.PushNotificationTemplateResponse = {
    import PushNotificationTemplateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.PushNotificationTemplateResponse
      .builder()
      .optionallyWith(adm.map(value => value.buildAwsValue()))(_.adm)
      .optionallyWith(apns.map(value => value.buildAwsValue()))(_.apns)
      .optionallyWith(
        arn.map(value => __string.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(baidu.map(value => value.buildAwsValue()))(_.baidu)
      .creationDate(__string.unwrap(creationDate): java.lang.String)
      .optionallyWith(defaultValue.map(value => value.buildAwsValue()))(
        _.defaultValue
      )
      .optionallyWith(
        defaultSubstitutions.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.defaultSubstitutions)
      .optionallyWith(gcm.map(value => value.buildAwsValue()))(_.gcm)
      .lastModifiedDate(__string.unwrap(lastModifiedDate): java.lang.String)
      .optionallyWith(
        recommenderId.map(value => __string.unwrap(value): java.lang.String)
      )(_.recommenderId)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> (__string.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        templateDescription.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.templateDescription)
      .templateName(__string.unwrap(templateName): java.lang.String)
      .templateType(templateType.unwrap)
      .optionallyWith(
        version.map(value => __string.unwrap(value): java.lang.String)
      )(_.version)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpoint.model.PushNotificationTemplateResponse.ReadOnly =
    zio.aws.pinpoint.model.PushNotificationTemplateResponse
      .wrap(buildAwsValue())
}
object PushNotificationTemplateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.PushNotificationTemplateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.PushNotificationTemplateResponse =
      zio.aws.pinpoint.model.PushNotificationTemplateResponse(
        adm.map(value => value.asEditable),
        apns.map(value => value.asEditable),
        arn.map(value => value),
        baidu.map(value => value.asEditable),
        creationDate,
        defaultValue.map(value => value.asEditable),
        defaultSubstitutions.map(value => value),
        gcm.map(value => value.asEditable),
        lastModifiedDate,
        recommenderId.map(value => value),
        tags.map(value => value),
        templateDescription.map(value => value),
        templateName,
        templateType,
        version.map(value => value)
      )
    def adm: Option[
      zio.aws.pinpoint.model.AndroidPushNotificationTemplate.ReadOnly
    ]
    def apns
        : Option[zio.aws.pinpoint.model.APNSPushNotificationTemplate.ReadOnly]
    def arn: Option[__string]
    def baidu: Option[
      zio.aws.pinpoint.model.AndroidPushNotificationTemplate.ReadOnly
    ]
    def creationDate: __string
    def defaultValue: Option[
      zio.aws.pinpoint.model.DefaultPushNotificationTemplate.ReadOnly
    ]
    def defaultSubstitutions: Option[__string]
    def gcm: Option[
      zio.aws.pinpoint.model.AndroidPushNotificationTemplate.ReadOnly
    ]
    def lastModifiedDate: __string
    def recommenderId: Option[__string]
    def tags: Option[Map[__string, __string]]
    def templateDescription: Option[__string]
    def templateName: __string
    def templateType: zio.aws.pinpoint.model.TemplateType
    def version: Option[__string]
    def getAdm: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.AndroidPushNotificationTemplate.ReadOnly
    ] = AwsError.unwrapOptionField("adm", adm)
    def getApns: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.APNSPushNotificationTemplate.ReadOnly
    ] = AwsError.unwrapOptionField("apns", apns)
    def getArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("arn", arn)
    def getBaidu: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.AndroidPushNotificationTemplate.ReadOnly
    ] = AwsError.unwrapOptionField("baidu", baidu)
    def getCreationDate: ZIO[Any, Nothing, __string] = ZIO.succeed(creationDate)
    def getDefaultValue: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.DefaultPushNotificationTemplate.ReadOnly
    ] = AwsError.unwrapOptionField("defaultValue", defaultValue)
    def getDefaultSubstitutions: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("defaultSubstitutions", defaultSubstitutions)
    def getGcm: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.AndroidPushNotificationTemplate.ReadOnly
    ] = AwsError.unwrapOptionField("gcm", gcm)
    def getLastModifiedDate: ZIO[Any, Nothing, __string] =
      ZIO.succeed(lastModifiedDate)
    def getRecommenderId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("recommenderId", recommenderId)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTemplateDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("templateDescription", templateDescription)
    def getTemplateName: ZIO[Any, Nothing, __string] = ZIO.succeed(templateName)
    def getTemplateType
        : ZIO[Any, Nothing, zio.aws.pinpoint.model.TemplateType] =
      ZIO.succeed(templateType)
    def getVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.PushNotificationTemplateResponse
  ) extends zio.aws.pinpoint.model.PushNotificationTemplateResponse.ReadOnly {
    override val adm: Option[
      zio.aws.pinpoint.model.AndroidPushNotificationTemplate.ReadOnly
    ] = scala
      .Option(impl.adm())
      .map(value =>
        zio.aws.pinpoint.model.AndroidPushNotificationTemplate.wrap(value)
      )
    override val apns
        : Option[zio.aws.pinpoint.model.APNSPushNotificationTemplate.ReadOnly] =
      scala
        .Option(impl.apns())
        .map(value =>
          zio.aws.pinpoint.model.APNSPushNotificationTemplate.wrap(value)
        )
    override val arn: Option[__string] = scala
      .Option(impl.arn())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val baidu: Option[
      zio.aws.pinpoint.model.AndroidPushNotificationTemplate.ReadOnly
    ] = scala
      .Option(impl.baidu())
      .map(value =>
        zio.aws.pinpoint.model.AndroidPushNotificationTemplate.wrap(value)
      )
    override val creationDate: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.creationDate())
    override val defaultValue: Option[
      zio.aws.pinpoint.model.DefaultPushNotificationTemplate.ReadOnly
    ] = scala
      .Option(impl.defaultValue())
      .map(value =>
        zio.aws.pinpoint.model.DefaultPushNotificationTemplate.wrap(value)
      )
    override val defaultSubstitutions: Option[__string] = scala
      .Option(impl.defaultSubstitutions())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val gcm: Option[
      zio.aws.pinpoint.model.AndroidPushNotificationTemplate.ReadOnly
    ] = scala
      .Option(impl.gcm())
      .map(value =>
        zio.aws.pinpoint.model.AndroidPushNotificationTemplate.wrap(value)
      )
    override val lastModifiedDate: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.lastModifiedDate())
    override val recommenderId: Option[__string] = scala
      .Option(impl.recommenderId())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val tags: Option[Map[__string, __string]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.pinpoint.model.primitives.__string(
              key
            ) -> zio.aws.pinpoint.model.primitives.__string(value)
          })
          .toMap
      )
    override val templateDescription: Option[__string] = scala
      .Option(impl.templateDescription())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val templateName: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.templateName())
    override val templateType: zio.aws.pinpoint.model.TemplateType =
      zio.aws.pinpoint.model.TemplateType.wrap(impl.templateType())
    override val version: Option[__string] = scala
      .Option(impl.version())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.PushNotificationTemplateResponse
  ): zio.aws.pinpoint.model.PushNotificationTemplateResponse.ReadOnly =
    new Wrapper(impl)
}
