package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class PutEventStreamRequest(
    applicationId: __string,
    writeEventStream: zio.aws.pinpoint.model.WriteEventStream
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.PutEventStreamRequest = {
    import PutEventStreamRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.PutEventStreamRequest
      .builder()
      .applicationId(__string.unwrap(applicationId): java.lang.String)
      .writeEventStream(writeEventStream.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.PutEventStreamRequest.ReadOnly =
    zio.aws.pinpoint.model.PutEventStreamRequest.wrap(buildAwsValue())
}
object PutEventStreamRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.PutEventStreamRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.PutEventStreamRequest =
      zio.aws.pinpoint.model
        .PutEventStreamRequest(applicationId, writeEventStream.asEditable)
    def applicationId: __string
    def writeEventStream: zio.aws.pinpoint.model.WriteEventStream.ReadOnly
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
    def getWriteEventStream
        : ZIO[Any, Nothing, zio.aws.pinpoint.model.WriteEventStream.ReadOnly] =
      ZIO.succeed(writeEventStream)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.PutEventStreamRequest
  ) extends zio.aws.pinpoint.model.PutEventStreamRequest.ReadOnly {
    override val applicationId: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.applicationId())
    override val writeEventStream
        : zio.aws.pinpoint.model.WriteEventStream.ReadOnly =
      zio.aws.pinpoint.model.WriteEventStream.wrap(impl.writeEventStream())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.PutEventStreamRequest
  ): zio.aws.pinpoint.model.PutEventStreamRequest.ReadOnly = new Wrapper(impl)
}
