package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class PutEventsRequest(
    applicationId: __string,
    eventsRequest: zio.aws.pinpoint.model.EventsRequest
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.PutEventsRequest = {
    import PutEventsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.PutEventsRequest
      .builder()
      .applicationId(__string.unwrap(applicationId): java.lang.String)
      .eventsRequest(eventsRequest.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.PutEventsRequest.ReadOnly =
    zio.aws.pinpoint.model.PutEventsRequest.wrap(buildAwsValue())
}
object PutEventsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.PutEventsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.PutEventsRequest =
      zio.aws.pinpoint.model
        .PutEventsRequest(applicationId, eventsRequest.asEditable)
    def applicationId: __string
    def eventsRequest: zio.aws.pinpoint.model.EventsRequest.ReadOnly
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
    def getEventsRequest
        : ZIO[Any, Nothing, zio.aws.pinpoint.model.EventsRequest.ReadOnly] =
      ZIO.succeed(eventsRequest)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.PutEventsRequest
  ) extends zio.aws.pinpoint.model.PutEventsRequest.ReadOnly {
    override val applicationId: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.applicationId())
    override val eventsRequest: zio.aws.pinpoint.model.EventsRequest.ReadOnly =
      zio.aws.pinpoint.model.EventsRequest.wrap(impl.eventsRequest())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.PutEventsRequest
  ): zio.aws.pinpoint.model.PutEventsRequest.ReadOnly = new Wrapper(impl)
}
