package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class PutEventsResponse(
    eventsResponse: zio.aws.pinpoint.model.EventsResponse
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.PutEventsResponse = {
    import PutEventsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.PutEventsResponse
      .builder()
      .eventsResponse(eventsResponse.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.PutEventsResponse.ReadOnly =
    zio.aws.pinpoint.model.PutEventsResponse.wrap(buildAwsValue())
}
object PutEventsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.PutEventsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.PutEventsResponse =
      zio.aws.pinpoint.model.PutEventsResponse(eventsResponse.asEditable)
    def eventsResponse: zio.aws.pinpoint.model.EventsResponse.ReadOnly
    def getEventsResponse
        : ZIO[Any, Nothing, zio.aws.pinpoint.model.EventsResponse.ReadOnly] =
      ZIO.succeed(eventsResponse)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.PutEventsResponse
  ) extends zio.aws.pinpoint.model.PutEventsResponse.ReadOnly {
    override val eventsResponse
        : zio.aws.pinpoint.model.EventsResponse.ReadOnly =
      zio.aws.pinpoint.model.EventsResponse.wrap(impl.eventsResponse())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.PutEventsResponse
  ): zio.aws.pinpoint.model.PutEventsResponse.ReadOnly = new Wrapper(impl)
}
